<?php 
$songQuery = mysqli_query($con, "SELECT id FROM songs ORDER BY RAND() LIMIT 10");
$resultArray = array();

while($row = mysqli_fetch_array($songQuery)) {
    array_push($resultArray, $row['id']);
}

$jsonArray = json_encode($resultArray);
?>

<script>
    $(document).ready(function() {
        var newPlaylist = <?php echo $jsonArray ?>;
        audioElement = new Audio();
        setTrack(newPlaylist[0], newPlaylist, false);
        updateVolumeProgressBar(audioElement.audio);

        $("#nowPlayingBarContainer").on("mousedown touchstart mousemove touchmove", function(e) {
            e.preventDefault();
        });

        $(".playbackBar .progressBar").mousedown(function() {
            mouseDown = true;
        });
        $(".playbackBar .progressBar").mousemove(function(e) {
            if(mouseDown) {
                var percent = e.offsetX / $(this).width();
                audioElement.audio.currentTime = audioElement.audio.duration * percent;
            }
        });
        $(".playbackBar .progressBar").mouseup(function(e) {
            var percent = e.offsetX / $(this).width();
            audioElement.audio.currentTime = audioElement.audio.duration * percent;
            mouseDown = false;
        });



        $(".volumeBar .progressBar").mousedown(function() {
            mouseDown = true;
        });
        $(".volumeBar .progressBar").mousemove(function(e) {
            if(mouseDown) {
                var percent = e.offsetX / $(this).width();
                if(percent > 0.1) {
                    audioElement.audio.volume = percent;
                }
            }
        });
        $(".volumeBar .progressBar").mouseup(function(e) {
            var percent = e.offsetX / $(this).width();
            if(percent > 0.1) {
                audioElement.audio.volume = percent;
            }
            mouseDown = false;
        });
    });

    

    function timeFromOffset(progressBar, mouse) {
        var percentage = mouse.offsetX / $(".progressBar . playbackBar").width() * 100;
        var seconds = audioElement.audio.duration * (percentage / 100);
        audioElement.setTime(seconds);
    }
    function prevSong() {    
        if(audioElement.audio.currentTime >= 3 || currentIndex == 0) {
            audioElement.setTime(0);
        }
        else {
            currentIndex = currentIndex - 1;
            setTrack(currentPlaylist[currentIndex], currentPlaylist, true)
            setTimeout(playSong, 100);

        }
    }
    function nextSong() {
        if(repeat == true) {
            audioElement.setTime(0);
            playSong();
            return;
        }

        if(currentIndex == currentPlaylist.length - 1) {
            currentIndex = 0;
        }
        else {
            currentIndex ++;
        }
        var trackToPlay = shuffle ? shufflePlaylist[currentIndex] : currentPlaylist[currentIndex];
        setTrack(currentPlaylist[currentIndex], currentPlaylist, true);
        setTimeout(playSong, 100);
    }

    
    function setRepeat() {
        repeat = !repeat;
        if(repeat == true) {
            $(".controlButton.repeat img").attr("src", "assets/images/icons/repeat-yellow.png");
        }
        else {
            $(".controlButton.repeat img").attr("src", "assets/images/icons/repeat.png");
        }
    }
    function setMute() {
        audioElement.audio.muted = !audioElement.audio.muted;
        if(audioElement.audio.muted) {
            $(".controlButton.volume img").attr("src", "assets/images/icons/volume-mute.png");
        }
        else {
            $(".controlButton.volume img").attr("src", "assets/images/icons/volume.png");
        }
    }
    function setShuffle() {
        shuffle = !shuffle;
        if(shuffle == true) {
            $(".controlButton.shuffle img").attr("src", "assets/images/icons/shuffle-yellow.png");
            shuffleArray(shufflePlaylist);
            currentPlaylist = shufflePlaylist.slice();
            currentIndex = shufflePlaylist.indexOf(audioElement.currentlyPlaying.id);
        }
        else {
            $(".controlButton.shuffle img").attr("src", "assets/images/icons/shuffle.png");
            currentIndex = currentPlaylist.indexOf(audioElement.currentlyPlaying.id);

        }
    }

    function shuffleArray(a) {
        var j, x, i;
        for (i = a.length; i; i--) {
            j = Math.floor(Math.random() * i);
            x = a[i - 1];
            a[i - 1] = a[j];
            a[j] = x;
        }
    }


    function setTrack(trackId, newPlaylist, play) {

        if(newPlaylist != currentPlaylist) {
            currentPlaylist = newPlaylist;
            shufflePlaylist = currentPlaylist.slice();
            shuffleArray(shufflePlaylist);
        }

        if(shuffle == true) {
            currentIndex = shufflePlaylist.indexOf(trackId);
        }
        else {
            currentIndex = currentPlaylist.indexOf(trackId);
        }

        $.post("includes/handlers/ajax/getSongJson.php", {songId: trackId}, function(data) { 

            var track = JSON.parse(data);
            $(".trackName span").text(track.title);

            $.post("includes/handlers/ajax/getArtistJson.php", {artistId: track.artist}, function(data) {
                var artist = JSON.parse(data);
                $(".artistName span").text(artist.name);
                
            });
            $.post("includes/handlers/ajax/getAlbumJson.php", {albumId: track.album}, function(data) {
                var album = JSON.parse(data);
                $(".albumLink img").attr("src", album.artworkPath);
            });
                audioElement.setTrack(track);

                if(play == true) {
                playSong();
            }
        });

        
    }
    function playSong() {

        if(audioElement.audio.currentTime == 0) {
            $.post("includes/handlers/ajax/updatePlays.php", {songId: audioElement.currentlyPlaying.id});
        }

        $(".controlButton.play").hide();
        $(".controlButton.pause").show();
        audioElement.play();
    }
    function pauseSong() {
        $(".controlButton.play").show();
        $(".controlButton.pause").hide();
        audioElement.pause();
    }
</script>

<div id="nowPlayingBarContainer">
    <div id="nowPlayingBar">
        <div id="nowPlayingLeft">
            <div class="content">
                <span class="albumLink">
                    <img src="" role="link" tabindex="0" onclick="openPage('album.php?id=' + audioElement.currentlyPlaying.album)" class="albumArtwork">
                </span>

                <div class="trackInfo">
                    <span class="trackName">
                        <span role="link" tabindex="0" onclick="openPage('song.php?id=' + audioElement.currentlyPlaying.id)"></span>
                    </span>

                    <span class="artistName">
                        <span role="link" tabindex="0" onclick="openPage('artist.php?id=' + audioElement.currentlyPlaying.artist)"></span></span>
                    </span>
                </div>
            </div>
        </div>  

        <div id="nowPlayingCenter">
            <div class="content playerControls">
                
                <div class="buttons">
                    <button class="controlButton shuffle" title="Shuffle button" onclick="setShuffle()">
                        <img src="assets/images/icons/shuffle.png" alt="Shuffle">
                    </button>
                    <button class="controlButton previous" title="Previous button" onclick="prevSong()">
                        <img src="assets/images/icons/previous.png" alt="Previous">
                    </button>
                    <button class="controlButton play" title="Play button" onclick="playSong()">
                        <img src="assets/images/icons/play.png" alt="Play">
                    </button>
                    <button class="controlButton pause" title="Pause button" style="display: none;" onclick="pauseSong()">
                        <img src="assets/images/icons/pause.png" alt="Pause">
                    </button>
                    <button class="controlButton next" title="Next button" onclick="nextSong()">
                        <img src="assets/images/icons/next.png" alt="Next">
                    </button>
                    <button class="controlButton repeat" title="Repeat button" onclick="setRepeat()">
                        <img src="assets/images/icons/repeat.png" alt="Repeat">
                    </button>
                </div>
                <div class="playbackBar">
                    <span class="progressTime current">0.00</span>

                    <div class="progressBar">
                        <div class="progressBarBg">
                            <div class="progress"></div>
                        </div>
                    </div>

                    <span class="progressTime remaining">0.00</span>
                </div>

            </div>
        </div>
        
        <div id="nowPlayingRight">
            <div class="volumeBar">
                <button class="controlButton volume" title="Volume button">
                    <img src="assets/images/icons/volume.png" alt="Volume" onclick="setMute()">
                </button>

                <div class="progressBar">
                        <div class="progressBarBg">
                            <div class="progress"></div>
                        </div>
                </div>
            </div>
        </div>   
    </div>
</div>