<?php
session_start();
require_once '../config/database.php';

// Ensure user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'] ?? null;

if ($role === 'admin') {
    $query = "SELECT * FROM tasks ORDER BY created_at DESC";
    $result = $conn->query($query);
} else {
    $query = "SELECT * FROM tasks WHERE assigned_to = ? ORDER BY created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>TaskPro Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 1100px;
            margin: auto;
            padding: 40px 20px;
        }
        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #2c3e50;
            color: white;
            padding: 20px 30px;
            border-radius: 0 0 12px 12px;
        }
        .logo {
            font-size: 26px;
            font-weight: 700;
        }
        .button-group a {
            padding: 10px 18px;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 20px;
            text-decoration: none;
            font-weight: 500;
            margin-left: 10px;
        }
        .button-group a:hover {
            background-color: #2980b9;
        }
        .profile p {
            font-size: 14px;
            text-align: right;
            margin: 0;
        }
        .task-overview {
            margin-top: 40px;
        }
        h2 {
            font-size: 26px;
            color: #333;
            text-align: center;
            margin-bottom: 30px;
        }
        .task-list {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 20px;
        }
        .task-card {
            background-color: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.08);
        }
        .task-card h3 {
            margin: 0 0 10px;
            font-size: 18px;
            color: #2c3e50;
        }
        .task-card p {
            margin: 5px 0;
            font-size: 14px;
        }
        .task-card a {
            display: inline-block;
            margin-top: 10px;
            font-size: 14px;
            color: #3498db;
            text-decoration: none;
            font-weight: bold;
        }
        .task-card a:hover {
            text-decoration: underline;
        }
        .no-tasks {
            text-align: center;
            margin-top: 50px;
            font-size: 18px;
            color: #888;
        }
        .task-card-link {
    text-decoration: none;
    color: inherit;
    transition: transform 0.1s ease-in-out;
}
.task-card-link:hover .task-card {
    transform: scale(1.02);
    box-shadow: 0 4px 14px rgba(0,0,0,0.15);
}
    .logout-btn {
        background-color: #888;
        color: white;
        font-weight: 500;
        padding: 10px 20px;
        border-radius: 6px;
        text-decoration: none;
        display: inline-block;
        margin-top: 10px;
        transition: background 0.3s ease;
        text-align: center;
    }

    .logout-btn:hover {
        background-color: #666;
    }
    </style>
</head>
<body>
<header>
    <div class="logo">TaskPro</div>
    <div>
        <div class="button-group">
            <?php if ($role === 'admin'): ?>
                <a href="assign_task.php">Assign Task</a>
                <a href="admin_panel.php">Manage Employees</a>
            <?php endif; ?>
        </div>
        <a href="logout.php" class="logout-btn">Logout</a>
    </div>
    <div class="profile">
        <p>
            <?php echo htmlspecialchars($_SESSION['name']); ?><br>
            <small><?php echo htmlspecialchars($_SESSION['email']); ?></small>
        </p>
    </div>
</header>
<div class="container">
    <div class="task-overview">
        <h2>Your Tasks</h2>

        <?php if ($result && $result->num_rows > 0): ?>
            <div class="task-list">
                <?php while ($task = $result->fetch_assoc()): ?>
                    <a href="view_task.php?id=<?= $task['id']; ?>" class="task-card-link">
    <div class="task-card">
        <h3><?php echo htmlspecialchars($task['task_name']); ?></h3>
        <p><strong>Due:</strong> <?php echo htmlspecialchars($task['due_date']); ?></p>
        <p><strong>Status:</strong> <?php echo htmlspecialchars($task['status']); ?></p>
        <?php if ($role === 'admin'): ?>
            <p style="margin-top: 10px; color: #888;">(Admin: click to edit)</p>
        <?php endif; ?>
    </div>
</a>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <p class="no-tasks">No tasks assigned.</p>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
