<?php
$current_page = basename($_SERVER['PHP_SELF']);
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}
require_once '../config/database.php';

$user_map = [];
$user_result = $conn->query("SELECT id, username FROM users");
while ($user = $user_result->fetch_assoc()) {
    $user_map[$user['id']] = $user['username'];
}
$comments_map = [];
$comments_result = $conn->query("
    SELECT c.task_id, c.comment, c.created_at, u.username 
    FROM task_comments c 
    JOIN users u ON c.user_id = u.id 
    ORDER BY c.created_at DESC
");
while ($row = $comments_result->fetch_assoc()) {
    $comments_map[$row['task_id']][] = $row;
}


$status_filter = $_GET['status'] ?? '';
$sort_order = $_GET['sort_due'] ?? 'ASC';

$params = [];
$conditions = [];
$sql = "SELECT * FROM tasks";

if ($_SESSION['role'] === 'worker') {
    $conditions[] = "assigned_to = ?";
    $params[] = $_SESSION['user_id'];
}

if (!empty($status_filter)) {
    $conditions[] = "status = ?";
    $params[] = $status_filter;
}

if (!empty($conditions)) {
    $sql .= " WHERE " . implode(" AND ", $conditions);
}

$sql .= " ORDER BY due_date " . ($sort_order === 'DESC' ? 'DESC' : 'ASC');

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $conn->query($sql);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Track Task - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .sidebar .menu a.active {
            background-color: #34495e;
            padding: 8px 12px;
            border-radius: 6px;
            display: inline-block;
        }
        .content {
            margin-left: 270px;
            padding: 40px;
            width: 100%;
        }
        h1 {
            text-align: center;
        }
        table {
            margin-top: 40px;
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        th, td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }
        th {
            background-color: #2c3e50;
            color: white;
        }
        .status-new {
            color: blue;
            font-weight: bold;
        }
        .status-in-progress {
            color: orange;
            font-weight: bold;
        }
        .status-completed {
            color: green;
            font-weight: bold;
        }
        .filter-form {
            margin-bottom: 20px;
        }
        .filter-form select {
            padding: 8px;
            margin-right: 10px;
        }
        .action-btns button {
            margin-right: 10px;
        }
        .edit-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            background-color: #2c3e50;
            color: white;
        }
        .delete-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            background-color: #e74c3c;
            color: white;
        }
        .modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0,0,0,0.5);
}
.modal-content {
    background-color: #fff;
    margin: 5% auto;
    padding: 30px;
    border-radius: 8px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}
.modal-content h2 {
    margin-top: 0;
    text-align: center;
    color: #2c3e50;
}
.modal-content input,
.modal-content textarea,
.modal-content select {
    width: 100%;
    padding: 8px;
    margin-bottom: 10px;
    border-radius: 4px;
    border: 1px solid #ccc;
    box-sizing: border-box;
}
.modal-content button {
    transition: background-color 0.3s, transform 0.2s;
    cursor: pointer;
}

.modal-content button:hover {
    transform: scale(1.03);
}

.modal-content button[type="submit"]:hover {
    background-color: #1a252f;
}

.modal-content button[type="button"]:hover {
    background-color: #b3b3b3;
}
    </style>
</head>
<script>
function toggleComments(taskId) {
    const section = document.getElementById('comments-' + taskId);
    if (section.style.display === 'none' || section.style.display === '') {
        section.style.display = 'block';
    } else {
        section.style.display = 'none';
    }
}
</script>
<body>
<div class="sidebar">
    <div class="logo"><a href="admin_home.php" style="color: white; text-decoration: none;">TaskPro</a></div>
    <ul class="menu">
        <li><a href="assign_task.php" class="<?php echo ($current_page == 'assign_task.php') ? 'active' : ''; ?>">Assign Task</a></li>
        <li><a href="admin_panel.php" class="<?php echo ($current_page == 'admin_panel.php') ? 'active' : ''; ?>">Manage Employees</a></li>
        <li><a href="track_task.php" class="<?php echo ($current_page == 'track_task.php') ? 'active' : ''; ?>">Track Task</a></li>
        <li><a href="report.php" class="<?php echo ($current_page == 'report.php') ? 'active' : ''; ?>">Reports</a></li>
        <li><a href="settings.php" class="<?php echo ($current_page == 'settings.php') ? 'active' : ''; ?>">Settings</a></li>
        <li><a href="logout.php">Logout</a></li>
    </ul>
</div>
<div class="content">
    <h1>Track Tasks</h1>
    <form class="filter-form" method="get" action="">
        <label for="status">Status:</label>
        <select name="status" id="status">
            <option value="">All</option>
            <option value="New" <?php if ($status_filter === 'New') echo 'selected'; ?>>New</option>
            <option value="In Progress" <?php if ($status_filter === 'In Progress') echo 'selected'; ?>>In Progress</option>
            <option value="Completed" <?php if ($status_filter === 'Completed') echo 'selected'; ?>>Completed</option>
        </select>
        <label for="sort_due">Sort by Due Date:</label>
        <select name="sort_due" id="sort_due">
            <option value="ASC" <?php if ($sort_order === 'ASC') echo 'selected'; ?>>Earliest First</option>
            <option value="DESC" <?php if ($sort_order === 'DESC') echo 'selected'; ?>>Latest First</option>
        </select>
        <button type="submit">Apply</button>
    </form>
    <div style="text-align: right; margin-bottom: 20px;">
    <form method="post" action="export_tasks.php" style="display: inline-block;">
        <button type="submit" style="padding: 10px 20px; background-color: #2c3e50; color: white; border: none; border-radius: 6px; cursor: pointer;">
            Export Tasks to Excel
        </button>
    </form>
</div>
    <?php if ($result && $result->num_rows > 0): ?>
        <table>
            <tr>
                <th>Task Name</th>
                <th>Assigned To</th>
                <th>Description</th>
                <th>Priority</th>
                <th>Due Date</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
            <?php while ($task = $result->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($task['task_name']); ?></td>
                    <td><?php echo htmlspecialchars($user_map[$task['assigned_to']] ?? 'Unknown'); ?></td>
                    <td><?php echo htmlspecialchars($task['description']); ?></td>
                    <td><?php echo htmlspecialchars($task['priority']); ?></td>
                    <td><?php echo htmlspecialchars($task['due_date']); ?></td>
                    <td class="status-<?php echo strtolower(str_replace(' ', '-', $task['status'])); ?>">
                        <?php echo htmlspecialchars($task['status']); ?>
                    </td>
                    <td class="action-btns">
    <button class="edit-btn" onclick="openEditModal(<?php echo htmlspecialchars(json_encode($task), ENT_QUOTES, 'UTF-8'); ?>)">Edit</button>
    <button class="edit-btn" onclick="toggleComments(<?php echo $task['id']; ?>)">Show Comments</button>
    <button class="delete-btn">Delete</button>
</td>
                </tr>
                <tr>
    <td colspan="7" style="padding: 0; border: none;">
        <div style="display: none;" id="comments-<?php echo $task['id']; ?>" class="comment-section">
            <div style="padding: 10px 20px; background: #f9f9f9; border-top: 1px solid #ddd;">
                <strong>Comments:</strong><br>
                <?php if (!empty($comments_map[$task['id']])): ?>
                    <?php foreach ($comments_map[$task['id']] as $comment): ?>
                        <p style="margin: 8px 0;">
                            <strong><?php echo htmlspecialchars($comment['username']); ?></strong>
                            <em style="color: #777; font-size: 12px;"><?php echo $comment['created_at']; ?></em><br>
                            <?php echo nl2br(htmlspecialchars($comment['comment'])); ?>
                        </p>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p style="color: #777;">No comments yet.</p>
                <?php endif; ?>
            </div>
        </div>
    </td>
</tr>

            <?php endwhile; ?>
        </table>
    <?php else: ?>
        <p style="text-align: center;">No tasks available.</p>
    <?php endif; ?>
</div>
<div id="editModal" class="modal">
    <div class="modal-content">
        <h2>Edit Task</h2>
        <form id="editTaskForm" method="post" action="update_task.php">
            <input type="hidden" name="id" id="edit-task-id">
            <label for="edit-task-name">Task Name:</label>
            <input type="text" name="task_name" id="edit-task-name" required><br><br>

            <label for="edit-assigned-to">Assigned To:</label>
            <select name="assigned_to" id="edit-assigned-to" required>
                <?php foreach ($user_map as $id => $username): ?>
                    <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($username); ?></option>
                <?php endforeach; ?>
            </select><br><br>

            <label for="edit-description">Description:</label>
            <textarea name="description" id="edit-description" rows="3" required></textarea><br><br>

            <label for="edit-priority">Priority:</label>
            <select name="priority" id="edit-priority" required>
                <option value="Low">Low</option>
                <option value="Medium">Medium</option>
                <option value="High">High</option>
            </select><br><br>

            <label for="edit-due-date">Due Date:</label>
            <input type="date" name="due_date" id="edit-due-date" required><br><br>

            <label for="edit-status">Status:</label>
            <select name="status" id="edit-status" required>
                <option value="New">New</option>
                <option value="In Progress">In Progress</option>
                <option value="Completed">Completed</option>
            </select><br><br>

            <div style="text-align: center;">
                <button type="submit" style="padding: 10px 20px; background-color: #2c3e50; color: white; border: none; border-radius: 6px;">Save Changes</button>
                <button type="button" onclick="closeEditModal()" style="padding: 10px 20px; background-color: #ccc; border: none; border-radius: 6px; margin-left: 10px;">Cancel</button>
            </div>
        </form>
    </div>
</div>
</div>
<script>
function openEditModal(task) {
    document.getElementById('editModal').style.display = 'block';
    document.getElementById('edit-task-id').value = task.id;
    document.getElementById('edit-task-name').value = task.task_name;
    document.getElementById('edit-assigned-to').value = task.assigned_to;
    document.getElementById('edit-description').value = task.description;
    document.getElementById('edit-priority').value = task.priority;
    document.getElementById('edit-due-date').value = task.due_date;
    document.getElementById('edit-status').value = task.status;
}

function closeEditModal() {
    document.getElementById('editModal').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target === document.getElementById('editModal')) {
        closeEditModal();
    }
}
</script>
</body>
</html>