<?php
$current_page = basename($_SERVER['PHP_SELF']);
session_start();

// Require DB connection
require_once '../config/database.php';

// Redirect to login if not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$error_message = "";

// Fetch user from DB
$query = "SELECT username, email, password FROM users WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($username, $email, $hashed_password);
$stmt->fetch();
$stmt->close();

// Pre-fill session variables
$_SESSION['name'] = $username;
$_SESSION['email'] = $email;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name']);
    $new_email = trim($_POST['email']);
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    // Update name and email
    if (!empty($name) && !empty($new_email)) {
        $update_stmt = $conn->prepare("UPDATE users SET username = ?, email = ? WHERE id = ?");
        $update_stmt->bind_param("ssi", $name, $new_email, $user_id);
        $update_stmt->execute();
        $update_stmt->close();

        $_SESSION['name'] = $name;
        $_SESSION['email'] = $new_email;
    }

    // Update password if fields are filled
    if (!empty($new_password) || !empty($confirm_password)) {
        if (!password_verify($current_password, $hashed_password)) {
            $error_message = "❌ Current password is incorrect.";
        } elseif ($new_password !== $confirm_password) {
            $error_message = "❌ New passwords do not match.";
        } else {
            $new_hashed = password_hash($new_password, PASSWORD_DEFAULT);
            $pass_stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $pass_stmt->bind_param("si", $new_hashed, $user_id);
            $pass_stmt->execute();
            $pass_stmt->close();

            // Redirect back to settings with success flag
            header("Location: settings.php?success=1");
            exit();
        }
    } else {
        // If no password update, still show success
        header("Location: settings.php?success=1");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .sidebar .menu a.active {
          background-color: #34495e;
          padding: 8px 12px;
          border-radius: 6px;
          display: inline-block;
        }
        .content {
            margin-left: 270px;
            padding: 20px;
            width: 100%;
        }
        h2 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        label {
            font-weight: 500;
            display: block;
            margin-top: 10px;
        }
        input {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        button {
            padding: 10px 20px;
            background-color: #2c3e50;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }
        button:hover {
            background-color: #1a252f;
        }
        .error-message {
            color: red;
            margin-bottom: 20px;
        }
        .success-message {
            color: green;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo"><a href="admin_home.php" style="color: white; text-decoration: none;">TaskPro</a></div>
        <ul class="menu">
    <li><a href="assign_task.php" class="<?php echo ($current_page == 'assign_task.php') ? 'active' : ''; ?>">Assign Task</a></li>
    <li><a href="admin_panel.php" class="<?php echo ($current_page == 'admin_panel.php') ? 'active' : ''; ?>">Manage Employees</a></li>
    <li><a href="track_task.php" class="<?php echo ($current_page == 'track_task.php') ? 'active' : ''; ?>">Track Task</a></li>
    <li><a href="report.php" class="<?php echo ($current_page == 'report.php') ? 'active' : ''; ?>">Reports</a></li>
    <li><a href="settings.php" class="<?php echo ($current_page == 'settings.php') ? 'active' : ''; ?>">Settings</a></li>
    <li><a href="logout.php">Logout</a></li>
</ul>
    </div>

    <div class="content">
        <h2>User Settings</h2>

        <?php if (!empty($error_message)): ?>
            <p class="error-message"><?php echo $error_message; ?></p>
        <?php endif; ?>

        <?php if (isset($_GET['success']) && $_GET['success'] == 1): ?>
            <p class="success-message">✅ Settings updated successfully.</p>
        <?php endif; ?>

        <form action="settings.php" method="post">
            <label for="name">Username:</label>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($_SESSION['name']); ?>" placeholder="Enter new username">

            <label for="email">Email:</label>
            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($_SESSION['email']); ?>" placeholder="Enter new email">

            <label for="current_password">Current Password (required to change password):</label>
            <input type="password" id="current_password" name="current_password" placeholder="Enter current password">

            <label for="new_password">New Password:</label>
            <input type="password" id="new_password" name="new_password" placeholder="Enter new password">

            <label for="confirm_password">Confirm New Password:</label>
            <input type="password" id="confirm_password" name="confirm_password" placeholder="Re-enter new password">

            <button type="submit">Update Settings</button>
        </form>
    </div>
</body>
</html>
