<?php
$current_page = basename($_SERVER['PHP_SELF']);
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}
require_once '../config/database.php';

// Optional: Better error reporting for debugging
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Fetch task stats
$query = "SELECT COUNT(*) as total_tasks, 
                 SUM(CASE WHEN status = 'Completed' THEN 1 ELSE 0 END) as completed_tasks, 
                 SUM(CASE WHEN status = 'In Progress' THEN 1 ELSE 0 END) as in_progress_tasks, 
                 SUM(CASE WHEN status = 'Overdue' THEN 1 ELSE 0 END) as overdue_tasks,
                 SUM(CASE WHEN priority = 'High' THEN 1 ELSE 0 END) as high_priority_tasks
          FROM tasks";
$result = $conn->query($query);
$stats = $result->fetch_assoc();

// ✅ FIXED: Use correct column name — assuming it's `task_name`
$recent_tasks = $conn->query("
    SELECT t.task_name, u.username AS assigned_user, t.status, t.priority
    FROM tasks t
    JOIN users u ON t.assigned_to = u.id
    ORDER BY t.created_at DESC
    LIMIT 5
");

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Task Report - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .sidebar .menu a.active {
            background-color: #34495e;
            padding: 8px 12px;
            border-radius: 6px;
            display: inline-block;
        }
        .content {
            margin-left: 270px;
            padding: 20px;
            width: 100%;
        }
        h1 {
            margin-bottom: 20px;
            text-align: center;
        }
        .stats-container {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
        }
        .stat-card {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 200px;
        }
        .stat-card h3 {
            font-size: 1.5em;
            margin-bottom: 10px;
        }
        .stat-card p {
            font-size: 1.2em;
            margin: 0;
        }
        .progress-container {
            margin-top: 40px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }
        .progress-label {
            font-weight: bold;
            margin-bottom: 10px;
        }
        .progress-bar {
            width: 100%;
            background-color: #e0e0e0;
            border-radius: 25px;
            overflow: hidden;
        }
        .progress-fill {
            height: 25px;
            background-color: #2c3e50;
            color: white;
            text-align: center;
            line-height: 25px;
            transition: width 0.5s ease;
        }
        .chart-container {
            max-width: 600px;
            margin: 40px auto;
        }
        .recent-tasks {
            max-width: 800px;
            margin: 40px auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .recent-tasks table {
            width: 100%;
            border-collapse: collapse;
        }
        .recent-tasks th, .recent-tasks td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .recent-tasks th {
            background-color: #2c3e50;
            color: white;
        }
    </style>
</head>
<body>
<div class="sidebar">
    <div class="logo"><a href="admin_home.php" style="color: white; text-decoration: none;">TaskPro</a></div>
    <ul class="menu">
        <li><a href="assign_task.php" class="<?php echo ($current_page == 'assign_task.php') ? 'active' : ''; ?>">Assign Task</a></li>
        <li><a href="admin_panel.php" class="<?php echo ($current_page == 'admin_panel.php') ? 'active' : ''; ?>">Manage Employees</a></li>
        <li><a href="track_task.php" class="<?php echo ($current_page == 'track_task.php') ? 'active' : ''; ?>">Track Task</a></li>
        <li><a href="report.php" class="<?php echo ($current_page == 'report.php') ? 'active' : ''; ?>">Reports</a></li>
        <li><a href="settings.php" class="<?php echo ($current_page == 'settings.php') ? 'active' : ''; ?>">Settings</a></li>
        <li><a href="logout.php">Logout</a></li>
    </ul>
</div>
<div class="content">
    <h1>Task Report</h1>
    <div class="stats-container">
        <div class="stat-card"><h3>Total Tasks</h3><p><?php echo $stats['total_tasks']; ?></p></div>
        <div class="stat-card"><h3>Completed</h3><p><?php echo $stats['completed_tasks']; ?></p></div>
        <div class="stat-card"><h3>In Progress</h3><p><?php echo $stats['in_progress_tasks']; ?></p></div>
        <div class="stat-card"><h3>Overdue</h3><p><?php echo $stats['overdue_tasks']; ?></p></div>
        <div class="stat-card"><h3>High Priority</h3><p><?php echo $stats['high_priority_tasks']; ?></p></div>
    </div>
    <div class="progress-container">
        <div class="progress-label">Task Completion</div>
        <?php
            $completion = $stats['total_tasks'] > 0 
                ? round(($stats['completed_tasks'] / $stats['total_tasks']) * 100) 
                : 0;
        ?>
        <div class="progress-bar">
            <div class="progress-fill" style="width: <?php echo $completion; ?>%;">
                <?php echo $completion; ?>%
            </div>
        </div>
    </div>
    <div class="chart-container">
        <canvas id="taskChart"></canvas>
    </div>
    <div class="recent-tasks">
        <h2>Recent Tasks</h2>
        <table>
            <thead>
                <tr><th>Task Name</th><th>Assigned To</th><th>Status</th><th>Priority</th></tr>
            </thead>
            <tbody>
            <?php while ($task = $recent_tasks->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($task['task_name']); ?></td>
                    <td><?php echo htmlspecialchars($task['assigned_user']); ?></td>
                    <td><?php echo htmlspecialchars($task['status']); ?></td>
                    <td><?php echo htmlspecialchars($task['priority']); ?></td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>
<script>
const ctx = document.getElementById('taskChart').getContext('2d');
new Chart(ctx, {
    type: 'pie',
    data: {
        labels: ['New', 'In Progress', 'Completed', 'Overdue'],
        datasets: [{
            label: 'Tasks',
            data: [
                <?php
                    // Calculate 'New' tasks dynamically
                    $new_tasks = $stats['total_tasks'] - $stats['completed_tasks'] - $stats['in_progress_tasks'] - $stats['overdue_tasks'];
                    echo $new_tasks;
                ?>,
                <?php echo $stats['in_progress_tasks']; ?>,
                <?php echo $stats['completed_tasks']; ?>,
                <?php echo $stats['overdue_tasks']; ?>
            ],
            backgroundColor: [
                '#3498db', // New - Blue
                '#f39c12', // In Progress - Orange
                '#2ecc71', // Completed - Green
                '#e74c3c'  // Overdue - Red
            ]
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});
</script>
</body>
</html>
