<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f7f7f7;
            position: relative; /* Allow positioning of watermark */
        }

        .register-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 300px;
            text-align: center;
            z-index: 1; /* Ensure this is above the watermark */
        }

        h2 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
        }

        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
            font-size: 14px;
            color: #555;
        }

        input[type="text"],
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 10px 10px; /* Added padding for left/right */
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box; /* Ensures padding is included in total width */
        }

        button {
            width: 100%;
            padding: 10px; /* Maintains existing padding */
            background-color: #1E90FF; /* Blue color */
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 10px; /* Space between buttons */
        }

        button:hover {
            background-color: #0056b3; /* Darker blue on hover */
        }

        p {
            margin-top: 15px;
            font-size: 14px;
        }

        p a {
            color: #1E90FF; /* Blue color */
            text-decoration: none;
        }

        p a:hover {
            text-decoration: underline;
        }

        /* Watermark style */
        .watermark {
            position: absolute; /* Positioning relative to the body */
            top: 10px; /* Adjust as necessary */
            right: 10px; /* Adjust as necessary */
            font-size: 50px; /* Size of the watermark */
            color: rgba(0, 0, 0, 0.1); /* Light color for watermark */
            pointer-events: none; /* Prevent interactions with the watermark */
            user-select: none; /* Prevent text selection */
        }
    </style>
</head>
<?php
 if ($_SERVER['REQUEST_METHOD'] === 'POST') {
     // Include database configuration
        require_once __DIR__ . '/../config/database.php';
        require_once __DIR__ . '/../vendor/autoload.php';
        $username = $_POST['username'];
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT); // Hash password

        // Check if email already exists
        $checkEmailQuery = "SELECT * FROM users WHERE email = ?";
        $stmt = $conn->prepare($checkEmailQuery);
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $error = "Email already registered!";
        } else {
            // Insert new user
            $query = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param('sss', $username, $email, $password);
            if ($stmt->execute()) {
                header('Location: login.php'); // Redirect to login after registration
                exit;
            } else {
                $error = "Registration failed!";
            }
        }
    }
?>
<body>
    <div class="watermark">TaskPro</div> <!-- Watermark element -->
    <div class="register-container">
        <h2>Register</h2>
        <?php if (isset($error)): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
        <form action="register.php" method="POST">
            <label for="username">Username:</label>
            <input type="text" id="username" name="username" required>

            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>

            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">Register</button>
        </form>
        <p>Already have an account? <a href="login.php">Login here</a></p>
    </div>
</body>
</html>
