<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login to TaskPro</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f7f7f7;
            position: relative;
        }

        .login-container, .reset-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 300px;
            text-align: center;
            z-index: 1;
        }

        h2 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
        }

        .message {
            display: none;
            color: green;
            margin-top: 10px;
        }

        .error {
            color: red;
            margin-bottom: 15px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
            font-size: 14px;
            color: #555;
        }

        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 10px 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }

        button {
            width: 100%;
            padding: 10px;
            background-color: #1E90FF;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 10px;
        }

        button:hover {
            background-color: #0056b3;
        }

        p {
            margin-top: 15px;
            font-size: 14px;
        }

        p a {
            color: #1E90FF;
            text-decoration: none;
        }

        p a:hover {
            text-decoration: underline;
        }

        .register-link {
            display: block;
            margin-top: 10px;
            color: #1E90FF;
            text-decoration: none;
            font-size: 14px;
        }

        .register-link:hover {
            text-decoration: underline;
        }

        .watermark {
            position: absolute;
            top: 10px;
            right: 10px;
            font-size: 50px;
            color: rgba(0, 0, 0, 0.1);
            pointer-events: none;
            user-select: none;
        }

        .hidden {
            display: none;
        }
    </style>
    <script>
        function showResetForm() {
            document.getElementById('loginForm').classList.add('hidden');
            document.getElementById('resetForm').classList.remove('hidden');
        }

        function sendResetLink(event) {
            event.preventDefault();
            document.getElementById('resetMessage').style.display = 'block';
            setTimeout(function() {
                document.getElementById('resetForm').classList.add('hidden');
                document.getElementById('loginForm').classList.remove('hidden');
                document.getElementById('resetMessage').style.display = 'none';
            }, 3000);
        }
    </script>
</head>
<body>
    <div class="watermark">TaskPro</div>
    <div class="login-container" id="loginForm">
        <h2>Login to TaskPro</h2>
        <?php
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }

        require_once '../config/database.php';

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $email = $_POST['email'];
            $password = $_POST['password'];

            $query = "SELECT id, username, role, password, email FROM users WHERE email = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param('s', $email);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows === 1) {
                $user = $result->fetch_assoc();

                if (password_verify($password, $user['password'])) {
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['username'] = $user['username'];
                    $_SESSION['role'] = $user['role'];
                    $_SESSION['name'] = $user['username'];
                   $_SESSION['email'] = $user['email'];
                    
                    if ($user['role'] === 'admin') {
                        header("Location: admin_home.php");
                    } else {
                        header("Location: worker.php");
                    }
                    exit();
                } else {
                    $error = "Invalid password.";
                }
            } else {
                $error = "Invalid email or password.";
            }
        }
        ?>
        <?php if (isset($error)): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
        <form method="POST" action="">
            <label for="email">Email</label>
            <input type="email" id="email" name="email" required>

            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">Login</button>
        </form>
        <p><a href="#" onclick="showResetForm()">Forgot your password?</a></p>
        <a href="register.php" class="register-link">Register here</a>
    </div>

    <div class="reset-container hidden" id="resetForm">
        <h2>Reset Your Password</h2>
        <form onsubmit="sendResetLink(event)">
            <label for="resetEmail">Enter your email:</label>
            <input type="email" id="resetEmail" name="resetEmail" required>
            <button type="submit">Send Reset Link</button>
            <p class="message" id="resetMessage">Sent!</p>
        </form>
    </div>
</body>
</html>
