<?php
require_once '../config/database.php';
session_start();

// Ensure only admins can export
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// Set headers for Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=task_export.xls");
header("Pragma: no-cache");
header("Expires: 0");

// Output HTML table
echo "<table border='1'>";
echo "<tr>
        <th>Task Name</th>
        <th>Description</th>
        <th>Assigned To</th>
        <th>Status</th>
        <th>Priority</th>
        <th>Due Date</th>
        <th>Created At</th>
      </tr>";

$query = "SELECT t.task_name, t.description, u.username AS assigned_to, t.status, t.priority, t.due_date, t.created_at
          FROM tasks t
          LEFT JOIN users u ON t.assigned_to = u.id
          ORDER BY t.created_at DESC";
$result = $conn->query($query);

while ($row = $result->fetch_assoc()) {
    echo "<tr>
            <td>" . htmlspecialchars($row['task_name']) . "</td>
            <td>" . htmlspecialchars($row['description']) . "</td>
            <td>" . htmlspecialchars($row['assigned_to']) . "</td>
            <td>" . htmlspecialchars($row['status']) . "</td>
            <td>" . htmlspecialchars($row['priority']) . "</td>
            <td>" . htmlspecialchars($row['due_date']) . "</td>
            <td>" . htmlspecialchars($row['created_at']) . "</td>
          </tr>";
}
echo "</table>";
exit();
