<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if the user is logged in and is an admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// Include database connection
require_once '../config/database.php';

// Fetch task details for editing
if (isset($_GET['id'])) {
    $task_id = $_GET['id'];
    $query = "SELECT * FROM tasks WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $task_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $task = $result->fetch_assoc();

    if (!$task) {
        echo "<p style='color: red;'>Task not found.</p>";
        exit();
    }
} else {
    echo "<p style='color: red;'>No task ID provided.</p>";
    exit();
}

// Handle form submission to update task
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $task_name = $_POST['task_name'];
    $description = $_POST['description'];
    $priority = $_POST['priority'];
    $due_date = $_POST['due_date'];
    $status = $_POST['status'];

    $query = "UPDATE tasks SET task_name = ?, description = ?, priority = ?, due_date = ?, status = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('sssssi', $task_name, $description, $priority, $due_date, $status, $task_id);

    if ($stmt->execute()) {
        // Redirect to admin panel after successful update
        header("Location: admin_panel.php");
        exit();
    } else {
        echo "<p style='color: red;'>Error: " . $stmt->error . "</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Task - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            margin-bottom: 20px;
        }
        form label {
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
        }
        form input, form textarea, form select {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        form button {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }
        form button:hover {
            background-color: #0056b3;
        }
       /* Back button styling */
.back-button {
    display: inline-block;
    margin-top: 10px;
    padding: 10px 20px;
    background-color: red; /* Changed to red */
    border-radius: 4px;
    color: white; /* White text */
    text-decoration: none;
}
.back-button:hover {
    background-color: #cc0000; /* Darker red on hover */
}

    </style>
</head>
<body>
    <div class="container">
        <h1>Edit Task</h1>
        <form method="POST" action="">
            <label for="task_name">Task Name</label>
            <input type="text" id="task_name" name="task_name" value="<?php echo htmlspecialchars($task['task_name']); ?>" required>

            <label for="description">Description</label>
            <textarea id="description" name="description" rows="5" required><?php echo htmlspecialchars($task['description']); ?></textarea>

            <label for="priority">Priority</label>
            <select id="priority" name="priority" required>
                <option value="Low" <?php if ($task['priority'] === 'Low') echo 'selected'; ?>>Low</option>
                <option value="Medium" <?php if ($task['priority'] === 'Medium') echo 'selected'; ?>>Medium</option>
                <option value="High" <?php if ($task['priority'] === 'High') echo 'selected'; ?>>High</option>
            </select>

            <label for="due_date">Due Date</label>
            <input type="date" id="due_date" name="due_date" value="<?php echo $task['due_date']; ?>" required>

            <label for="status">Status</label>
            <select id="status" name="status" required>
                <option value="New" <?php if ($task['status'] === 'New') echo 'selected'; ?>>New</option>
                <option value="In Progress" <?php if ($task['status'] === 'In Progress') echo 'selected'; ?>>In Progress</option>
                <option value="Completed" <?php if ($task['status'] === 'Completed') echo 'selected'; ?>>Completed</option>
            </select>

            <button type="submit">Update Task</button>
        </form>
        
        <!-- Back button to return to admin panel -->
        <a href="admin_panel.php" class="back-button">Back</a>
    </div>
</body>
</html>
