<?php
$current_page = basename($_SERVER['PHP_SELF']);
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Redirect if not logged in
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// Include DB connection
require_once '../config/database.php';

// Fetch all employees from the users table (for dropdown)
$employees = [];
$result = $conn->query("SELECT id, username FROM users WHERE role = 'worker'");
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $employees[] = $row;
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['assign_task'])) {
    $task_name = $_POST['task_name'];
    $assigned_to = (int) $_POST['assign_employee']; // user_id
    $description = $_POST['task_description'];
    $priority = $_POST['priority'];
    $due_date = $_POST['due_date'];

    $query = "INSERT INTO tasks (task_name, assigned_to, description, priority, due_date, status)
              VALUES (?, ?, ?, ?, ?, 'New')";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('sisss', $task_name, $assigned_to, $description, $priority, $due_date);

    if ($stmt->execute()) {
        header("Location: admin_panel.php");
        exit();
    } else {
        echo "<p style='color: red;'>Error: " . $stmt->error . "</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Assign Task - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
    font-family: 'Roboto', sans-serif;
    background-color: #f4f4f9;
    padding: 20px;
    display: flex;
    overflow-y: auto;  
}

        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        
        .sidebar .menu a.active {
    background-color: #34495e;
    padding: 8px 12px;
    border-radius: 6px;
    display: inline-block;
}
        
        .content {
    margin-left: 270px;
    padding: 20px;
    width: calc(100% - 270px); 
    box-sizing: border-box;
}

        h1 {
            margin-bottom: 20px;
            text-align: center;
        }
        .assign-task-form {
    max-width: 700px;
    margin: 0 auto;
}
        .assign-task-form label {
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
        }
        .assign-task-form input,
.assign-task-form textarea,
.assign-task-form select {
    width: 100%;
    padding: 10px;
    margin-bottom: 20px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-family: inherit;
}
        .assign-task-form button {
            padding: 10px 20px;
            background-color: #2c3e50;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }
        .assign-task-form button:hover {
            background-color: #1a252f;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo"><a href="track_task.php" style="color: white; text-decoration: none;">TaskPro</a></div>
        <ul class="menu">
    <li><a href="assign_task.php" class="<?php echo ($current_page == 'assign_task.php') ? 'active' : ''; ?>">Assign Task</a></li>
    <li><a href="admin_panel.php" class="<?php echo ($current_page == 'admin_panel.php') ? 'active' : ''; ?>">Manage Employees</a></li>
    <li><a href="track_task.php" class="<?php echo ($current_page == 'track_task.php') ? 'active' : ''; ?>">Track Task</a></li>
    <li><a href="report.php" class="<?php echo ($current_page == 'report.php') ? 'active' : ''; ?>">Reports</a></li>
    <li><a href="settings.php" class="<?php echo ($current_page == 'settings.php') ? 'active' : ''; ?>">Settings</a></li>
    <li><a href="logout.php">Logout</a></li>
</ul>
    </div>

    <div class="content">
        <h1>Assign a New Task</h1>
        <div class="assign-task-form">
            <form method="POST" action="assign_task.php">
                <label for="task_name">Task Name</label>
                <input type="text" id="task_name" name="task_name" required>

                <label for="assign_employee">Assign to Employee</label>
                <select id="assign_employee" name="assign_employee" required>
                    <option value="">-- Select Employee --</option>
                    <?php foreach ($employees as $employee): ?>
                        <option value="<?= $employee['id'] ?>">
                            <?= htmlspecialchars($employee['username']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <label for="task_description">Task Description</label>
                <textarea id="task_description" name="task_description" rows="5" required></textarea>

                <label>Priority Level</label>
                <select id="priority" name="priority" required>
                    <option value="Low">Low</option>
                    <option value="Medium">Medium</option>
                    <option value="High">High</option>
                </select>

                <label for="due_date">Due Date</label>
                <input type="date" id="due_date" name="due_date" required>

                <button type="submit" name="assign_task">Submit Task</button>
            </form>
        </div>
    </div>
</body>
</html>
