<?php
$current_page = basename($_SERVER['PHP_SELF']);
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

require_once '../config/database.php';

$add_employee_message = "";
$edit_employee_message = "";

// DELETE LOGIC
if (isset($_GET['delete_employee'])) {
    $employee_id = $_GET['delete_employee'];
    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $employee_id);
    if ($stmt->execute()) {
        $_SESSION['deleted_msg'] = "Employee deleted successfully.";
        header("Location: admin_panel.php");
        exit();
    } else {
        $edit_employee_message = "<p style='color: red;'>Error deleting employee: " . $stmt->error . "</p>";
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_employee'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $role = $_POST['role'];

    if ($password !== $confirm_password) {
        $add_employee_message = "<p style='color: red;'>Error: Passwords do not match.</p>";
    } else {
        $check = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $check->bind_param("s", $email);
        $check->execute();
        $check_result = $check->get_result();

        if ($check_result->num_rows > 0) {
            $add_employee_message = "<p style='color: red;'>Error: Email already exists.</p>";
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $query = "INSERT INTO users (username, email, password, role) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param('ssss', $name, $email, $hashed_password, $role);

            if ($stmt->execute()) {
                $add_employee_message = "<p style='color: green;'>Employee added successfully!</p>";
            } else {
                $add_employee_message = "<p style='color: red;'>Error: " . $stmt->error . "</p>";
            }
        }
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_employee_id'])) {
    $id = $_POST['edit_employee_id'];
    $new_name = $_POST['edit_name'];
    $new_email = $_POST['edit_email'];
    $new_role = $_POST['edit_role']; // ✅ Make sure this line exists!

    $check = $conn->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
    $check->bind_param("si", $new_email, $id);
    $check->execute();
    $check_result = $check->get_result();

    if ($check_result->num_rows > 0) {
        $edit_employee_message = "<p style='color: red;'>Error: Email already in use by another user.</p>";
    } else {
        $stmt = $conn->prepare("UPDATE users SET username = ?, email = ?, role = ? WHERE id = ?");
        if ($stmt === false) {
            $edit_employee_message = "<p style='color: red;'>Prepare failed: " . $conn->error . "</p>";
        } else {
            $stmt->bind_param("sssi", $new_name, $new_email, $new_role, $id); // ✅ Exactly 4 params
            if ($stmt->execute()) {
                $edit_employee_message = "<p style='color: green;'>Employee updated successfully!</p>";
            } else {
                $edit_employee_message = "<p style='color: red;'>Error: " . $stmt->error . "</p>";
            }
        }
    }
}


$result = $conn->query("SELECT id, username, email, role FROM users");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>TaskPro - Admin Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            display: flex;
        }

        .sidebar {
            width: 200px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }

        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .sidebar .logo a {
            color: white;
            text-decoration: none;
        }

        .sidebar .menu {
            list-style: none;
            padding: 0;
        }

        .sidebar .menu li {
            margin-bottom: 15px;
        }

        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }

        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        
        .sidebar .menu a.active {
    background-color: #34495e;
    padding: 8px 12px;
    border-radius: 6px;
    display: inline-block;
}

        .content {
            margin-left: 270px;
            padding: 40px;
            width: 100%;
        }

        h1, h2 {
            text-align: center;
        }

        .add-employee-form {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            max-width: 600px;
            margin: 0 auto;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .add-employee-form label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }

        .add-employee-form input,
        .add-employee-form select {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }

        .add-employee-form button {
            padding: 10px 20px;
            background-color: #2c3e50;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: bold;
        }

        .add-employee-form button:hover {
            background-color: #1a252f;
        }

        table {
            margin-top: 40px;
            width: 100%;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }

        th, td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: #2c3e50;
            color: white;
        }

        .action-btns button {
            margin-right: 10px;
        }

        .edit-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            background-color: #2c3e50;
            color: white;
            transition: background-color 0.2s ease-in-out;
        }

        .edit-btn:hover {
            background-color: #1a252f;
        }

        .delete-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            background-color: #e74c3c;
            color: white;
            transition: background-color 0.2s ease-in-out;
        }

        .delete-btn:hover {
            background-color: #c0392b;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.5);
        }

        .modal-content {
            background-color: #fff;
            margin: 10% auto;
            padding: 30px;
            border-radius: 8px;
            width: 100%;
            max-width: 500px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }

        .modal-content h2 {
            margin-top: 0;
            text-align: center;
            color: #2c3e50;
        }

        .modal-content label {
            display: block;
            margin-top: 15px;
            font-weight: 500;
        }

        .modal-content input {
            width: 100%;
            padding: 10px;
            margin-top: 8px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }

        .modal-content .btn-group {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        .modal-content button {
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
        }

        .save-btn {
            background-color: #2c3e50;
            color: white;
        }

        .cancel-btn {
            background-color: #ccc;
            color: #333;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo"><a href="admin_home.php">TaskPro</a></div>
       <ul class="menu">
    <li><a href="assign_task.php" class="<?php echo ($current_page == 'assign_task.php') ? 'active' : ''; ?>">Assign Task</a></li>
    <li><a href="admin_panel.php" class="<?php echo ($current_page == 'admin_panel.php') ? 'active' : ''; ?>">Manage Employees</a></li>
    <li><a href="track_task.php" class="<?php echo ($current_page == 'track_task.php') ? 'active' : ''; ?>">Track Task</a></li>
    <li><a href="report.php" class="<?php echo ($current_page == 'report.php') ? 'active' : ''; ?>">Reports</a></li>
    <li><a href="settings.php" class="<?php echo ($current_page == 'settings.php') ? 'active' : ''; ?>">Settings</a></li>
    <li><a href="logout.php">Logout</a></li>
</ul>
    </div>

    <div class="content">
        <h1>Manage Employees</h1>
        <h2>Add New Employee</h2>

        <div class="add-employee-form">
            <?php if ($add_employee_message): ?>
                <div id="message"><?php echo $add_employee_message; ?></div>
            <?php endif; ?>
            <form method="POST" action="">
                <label for="name">Name</label>
                <input type="text" id="name" name="name" required>
                <label for="email">Email</label>
                <input type="email" id="email" name="email" required>
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
                <label for="confirm_password">Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
                <label for="role">Role</label>
                <select id="role" name="role" required>
                    <option value="worker">Worker</option>
                    <option value="admin">Admin</option>
                </select>
                <button type="submit" name="add_employee">Add Employee</button>
            </form>
        </div>
        <h2>Worker List</h2>
         <?php if (isset($_SESSION['deleted_msg'])): ?>
            <p id="message" style="color: green; text-align: center;">
        <?php echo $_SESSION['deleted_msg']; unset($_SESSION['deleted_msg']); ?>
          </p>
        <?php endif; ?>
        <table>
            <thead>
    <tr>
        <th>Name</th>
        <th>Email</th>
        <th>Role</th>
        <th>Actions</th>
    </tr>
</thead>
<tbody>
    <?php while ($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?php echo htmlspecialchars($row['username']); ?></td>
            <td><?php echo htmlspecialchars($row['email']); ?></td>
            <td><?php echo htmlspecialchars($row['role']); ?></td>
            <td class="action-btns">

<button class="edit-btn" onclick="openEditModal(
    <?php echo $row['id']; ?>,
    '<?php echo htmlspecialchars($row['username'], ENT_QUOTES); ?>',
    '<?php echo htmlspecialchars($row['email'], ENT_QUOTES); ?>',
    '<?php echo $row['role']; ?>'
)">Edit</button>
                            <button class="delete-btn" onclick="if(confirm('Are you sure you want to delete this employee?')) window.location.href='admin_panel.php?delete_employee=<?php echo $row['id']; ?>';">Delete</button>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <div id="editModal" class="modal">
        <div class="modal-content">
            <h2>Edit Employee</h2>
            <form id="editEmployeeForm" method="POST">
                <input type="hidden" name="edit_employee_id" id="edit_employee_id">
                <label for="edit_name">Name</label>
                <input type="text" name="edit_name" id="edit_name" required>
                <label for="edit_email">Email</label>
                <input type="email" name="edit_email" id="edit_email" required>
                <label for="edit_role">Role</label>
                <select name="edit_role" id="edit_role" required>
                    <option value="worker">Worker</option>
                    <option value="admin">Admin</option>
                </select>
                <div class="btn-group">
                    <button type="submit" class="save-btn">Save</button>
                    <button type="button" class="cancel-btn" onclick="closeModal()">Cancel</button>
                </div>
            </form>
        </div>
    </div>
    <script>
    function openEditModal(id, name, email, role) {
        document.getElementById('edit_employee_id').value = id;
        document.getElementById('edit_name').value = name;
        document.getElementById('edit_email').value = email;
        document.getElementById('edit_role').value = role;
        document.getElementById('editModal').style.display = 'block';
    }
    function closeModal() {
        document.getElementById('editModal').style.display = 'none';
    }
    window.onclick = function(event) {
        const modal = document.getElementById('editModal');
        if (event.target == modal) {
            closeModal();
        }
    }
    </script>
    <script>
    // Hide success or error message after 3 seconds
    window.addEventListener('DOMContentLoaded', () => {
        const messageBox = document.getElementById('message');
        if (messageBox) {
            setTimeout(() => {
                messageBox.style.transition = 'opacity 0.5s ease';
                messageBox.style.opacity = '0';
                setTimeout(() => messageBox.remove(), 500);
            }, 3000);
        }
    });
</script>
</body>
</html>
