<?php
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>TaskPro - Admin Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            margin: 0;
            padding: 0;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .logo a {
            color: white;
            text-decoration: none;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .content {
            margin-left: 270px;
            padding: 40px;
            width: 100%;
        }
        h1 {
            margin-bottom: 10px;
            text-align: center;
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 40px;
        }
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }
        .card {
            background-color: white;
            padding: 30px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            transition: transform 0.2s, box-shadow 0.2s;
            text-decoration: none;
            color: #2c3e50;
            font-weight: bold;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo"><a href="admin_home.php">TaskPro</a></div>
        <ul class="menu">
            <li><a href="assign_task.php">Assign Task</a></li>
            <li><a href="admin_panel.php">Manage Employees</a></li>
            <li><a href="track_task.php">Track Task</a></li>
            <li><a href="report.php">Reports</a></li>
            <li><a href="settings.php">Settings</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </div>

    <div class="content">
        <h1>TaskPro - Admin Panel</h1>
        <h2>Welcome, Admin!</h2>
        <div class="cards">
            <a class="card" href="assign_task.php">
                <h3>Assign Tasks</h3>
            </a>
            <a class="card" href="admin_panel.php">
                <h3>Manage Employees</h3>
            </a>
            <a class="card" href="track_task.php">
                <h3>Track Tasks</h3>
            </a>
            <a class="card" href="report.php">
                <h3>View Reports</h3>
            </a>
            <a class="card" href="settings.php">
                <h3>Settings</h3>
            </a>
        </div>
    </div>
</body>
</html>
