<?php 
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include the database connection file
require_once '../config/database.php';

// Set default session values for demonstration purposes
if (!isset($_SESSION['name'])) {
    $_SESSION['name'] = 'Gari Poter'; // Default name
}
if (!isset($_SESSION['email'])) {
    $_SESSION['email'] = 'GarryPotter@hotmail.ru'; // Default email
}

// Get the logged-in user's role and ID
$user_id = $_SESSION['user_id'] ?? null;
$role = $_SESSION['role'] ?? 'worker'; // Default to worker if role not set

// Fetch tasks based on the user's role
if ($role === 'admin') {
    // Admin can see all tasks
    $query = "SELECT * FROM tasks ORDER BY created_at DESC";
    $result = $conn->query($query);
} else {
    // Workers can only see tasks assigned to them
    $query = "SELECT * FROM tasks WHERE assigned_to = ? ORDER BY created_at DESC";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('s', $_SESSION['name']);
    $stmt->execute();
    $result = $stmt->get_result();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TaskPro Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .logo {
            font-size: 24px;
            font-weight: 700;
            color: #222;
            display: flex;
            align-items: center;
        }

        .menu-icon {
            margin-right: 10px;
        }

        .button-group {
            display: flex;
            gap: 10px;
        }

        .button-group button,
        .button-group a {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
            text-decoration: none;
            display: inline-block;
        }

        .button-group a:hover,
        .button-group button:hover {
            background-color: #0056b3;
        }

        .profile {
            display: flex;
            align-items: center;
        }

        .profile img {
            border-radius: 50%;
            width: 50px;
            height: 50px;
            margin-left: 10px;
        }

        .profile p {
            margin-right: 10px;
            color: #666;
            font-size: 14px;
        }

        .task-overview {
            margin: 20px 0;
        }

        h2 {
            font-size: 24px;
            margin-bottom: 20px;
        }

        .task-columns {
            display: flex;
            gap: 20px;
        }

        .column {
            flex: 1;
            background-color: #e0e0e0;
            padding: 20px;
            border-radius: 8px;
        }

        .column h3 {
            font-size: 18px;
            margin-bottom: 15px;
        }

        .task-item {
            background-color: white;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 10px;
        }

        .task-item:last-child {
            margin-bottom: 0;
        }

        .task-controls {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }

        .task-controls button {
            background-color: white;
            color: #222;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 20px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="logo">
                <span class="menu-icon">&#9776;</span>
                <span>TaskPro</span>
            </div>

            <div class="button-group">
                <?php if ($role === 'admin'): ?>
                    <a href="assign_task.php" class="button">Assign Task</a>
                    <a href="admin_panel.php" class="button">Manage Employees</a>
                <?php endif; ?>
                <a href="logout.php" class="button">Logout</a>
            </div>

            <div class="profile">
                <p><?php echo $_SESSION['name']; ?> <br> <?php echo $_SESSION['email']; ?></p>
                <img src="https://shorturl.at/44zLJ" alt="Profile">
            </div>
        </header>

        <div class="task-controls">
            <button>Filter</button>
            <button>Sort</button>
        </div>

        <div class="task-overview">
            <h2>Your Tasks</h2>
            <div class="task-columns">
                <!-- Display tasks -->
                <div class="column">
                    <h3>Tasks</h3>
                    <?php if ($result && $result->num_rows > 0): ?>
                        <?php while ($task = $result->fetch_assoc()): ?>
                            <div class="task-item">
                                <strong><?php echo htmlspecialchars($task['task_name']); ?></strong><br>
                                Due: <?php echo htmlspecialchars($task['due_date']); ?><br>
                                Status: <?php echo htmlspecialchars($task['status']); ?><br>
                                <?php if ($role === 'admin'): ?>
                                    <a href="edit_task.php?id=<?php echo $task['id']; ?>">Edit</a>
                                <?php endif; ?>
                            </div>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <p>No tasks available.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</body>
</html>