<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if the user is logged in
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}

// Include database connection
require_once '../config/database.php';

// Fetch all tasks to generate a report
$query = "SELECT * FROM tasks ORDER BY due_date ASC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Task Report - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .content {
            margin-left: 270px;
            padding: 20px;
            width: 100%;
        }
        h1 {
            margin-bottom: 20px;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const links = document.querySelectorAll('.menu a');
            links.forEach(link => {
                link.addEventListener('click', function (e) {
                    e.preventDefault();
                    window.location.href = this.getAttribute('href');
                });
            });

            // Ensure the report link does not open in a new tab
            const reportLink = document.querySelector('.menu a[href="report.php"]');
            if (reportLink) {
                reportLink.removeAttribute('target');
            }
        });
    </script>
</head>
<body>
    <div class="sidebar">
        <div class="logo">TaskPro</div>
        <ul class="menu">
            <li><a href="assign_task.php">Assign Task</a></li>
            <li><a href="admin_panel.php">Manage Employees</a></li>
            <li><a href="track_task.php">Track Task</a></li>
            <li><a href="report.php">Reports</a></li>
            <li><a href="settings.php">Settings</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </div>

    <div class="content">
        <h1>Task Report</h1>

        <table>
            <tr>
                <th>ID</th>
                <th>Task Name</th>
                <th>Assigned To</th>
                <th>Description</th>
                <th>Priority</th>
                <th>Due Date</th>
                <th>Status</th>
            </tr>
            <?php if ($result && $result->num_rows > 0): ?>
                <?php while ($task = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $task['id']; ?></td>
                        <td><?php echo htmlspecialchars($task['task_name']); ?></td>
                        <td><?php echo htmlspecialchars($task['assigned_to']); ?></td>
                        <td><?php echo htmlspecialchars($task['description']); ?></td>
                        <td><?php echo htmlspecialchars($task['priority']); ?></td>
                        <td><?php echo htmlspecialchars($task['due_date']); ?></td>
                        <td><?php echo htmlspecialchars($task['status']); ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" style="text-align: center;">No tasks available.</td>
                </tr>
            <?php endif; ?>
        </table>
    </div>
</body>
</html>
