<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if the user is logged in
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}

// Include database connection
require_once '../config/database.php';

// Fetch task statistics
$query = "SELECT COUNT(*) as total_tasks, 
                 SUM(CASE WHEN status = 'Completed' THEN 1 ELSE 0 END) as completed_tasks, 
                 SUM(CASE WHEN status = 'In Progress' THEN 1 ELSE 0 END) as in_progress_tasks, 
                 SUM(CASE WHEN status = 'Overdue' THEN 1 ELSE 0 END) as overdue_tasks,
                 SUM(CASE WHEN priority = 'High' THEN 1 ELSE 0 END) as high_priority_tasks
          FROM tasks";
$result = $conn->query($query);
$stats = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Task Report - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .content {
            margin-left: 270px;
            padding: 20px;
            width: 100%;
        }
        h1 {
            margin-bottom: 20px;
            text-align: center;
        }
        .stats-container {
            display: flex;
            justify-content: space-around;
            margin-top: 20px;
        }
        .stat-card {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 200px;
        }
        .stat-card h3 {
            font-size: 1.5em;
            margin-bottom: 10px;
        }
        .stat-card p {
            font-size: 1.2em;
            margin: 0;
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const links = document.querySelectorAll('.menu a');
            links.forEach(link => {
                link.addEventListener('click', function (e) {
                    e.preventDefault();
                    window.location.href = this.getAttribute('href');
                });
            });

            // Ensure the report link does not open in a new tab
            const reportLink = document.querySelector('.menu a[href="report.php"]');
            if (reportLink) {
                reportLink.removeAttribute('target');
            }
        });
    </script>
</head>
<body>
    <div class="sidebar">
        <div class="logo">TaskPro</div>
        <ul class="menu">
            <li><a href="assign_task.php">Assign Task</a></li>
            <li><a href="admin_panel.php">Manage Employees</a></li>
            <li><a href="track_task.php">Track Task</a></li>
            <li><a href="report.php">Reports</a></li>
            <li><a href="settings.php">Settings</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </div>

    <div class="content">
        <h1>Task Report</h1>

        <div class="stats-container">
            <div class="stat-card">
                <h3>Total Tasks</h3>
                <p><?php echo $stats['total_tasks']; ?></p>
            </div>
            <div class="stat-card">
                <h3>Completed Tasks</h3>
                <p><?php echo $stats['completed_tasks']; ?></p>
            </div>
            <div class="stat-card">
                <h3>In Progress</h3>
                <p><?php echo $stats['in_progress_tasks']; ?></p>
            </div>
            <div class="stat-card">
                <h3>Overdue Tasks</h3>
                <p><?php echo $stats['overdue_tasks']; ?></p>
            </div>
            <div class="stat-card">
                <h3>High Priority</h3>
                <p><?php echo $stats['high_priority_tasks']; ?></p>
            </div>
        </div>
    </div>
</body>
</html>
