<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if the user is logged in
if (!isset($_SESSION['role'])) {
    header("Location: login.php");
    exit();
}

// Include database connection
require_once '../config/database.php';

// Handle form submission to assign a task
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['assign_task'])) {
    $task_name = $_POST['task_name'];
    $assigned_to = $_POST['assign_employee'];
    $description = $_POST['task_description'];
    $priority = $_POST['priority'];
    $due_date = $_POST['due_date'];

    $query = "INSERT INTO tasks (task_name, assigned_to, description, priority, due_date, status) VALUES (?, ?, ?, ?, ?, 'New')";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('sssss', $task_name, $assigned_to, $description, $priority, $due_date);

   if ($stmt->execute()) {
    // Redirect to admin panel after task is assigned
    header("Location: admin_panel.php");
    exit(); // Ensure the script stops here after redirection
} else {
    echo "<p style='color: red;'>Error: " . $stmt->error . "</p>";
}
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assign Task - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .content {
            margin-left: 270px;
            padding: 20px;
            width: 100%;
        }
        h1 {
            margin-bottom: 20px;
            text-align: center;
        }
        .assign-task-form {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .assign-task-form label {
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
        }
        .assign-task-form input,
        .assign-task-form textarea,
        .assign-task-form select {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .assign-task-form button {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }
        .assign-task-form button:hover {
            background-color: #0056b3;
        }
        .back-button {
    display: inline-block;
    margin-top: 10px;
    padding: 10px 20px;
    background-color: red; /* Changed to red */
    border-radius: 4px;
    color: white; /* White text */
    text-decoration: none;
}
.back-button:hover {
    background-color: #cc0000; /* Darker red on hover */
}
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo">TaskPro</div>
        <ul class="menu">
            <li><a href="assign_task.php">Assign Task</a></li>
            <li><a href="admin_panel.php">Manage Employees</a></li>
            <li><a href="track_task.php">Track Task</a></li>
            <li><a href="report.php" target="_blank">Reports</a></li>
            <li><a href="settings.php">Settings</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </div>

    <div class="content">
        <h1>Assign a New Task</h1>

        <div class="assign-task-form">
            <form method="POST" action="assign_task.php">
                <label for="task_name">Task Name</label>
                <input type="text" id="task_name" name="task_name" required>

                <label for="assign_employee">Assign to Employee</label>
                <input type="text" id="assign_employee" name="assign_employee" required>

                <label for="task_description">Task Description</label>
                <textarea id="task_description" name="task_description" rows="5" required></textarea>

                <label>Priority Level</label>
                <select id="priority" name="priority" required>
                    <option value="Low">Low</option>
                    <option value="Medium">Medium</option>
                    <option value="High">High</option>
                </select>

                <label for="due_date">Due Date</label>
                <input type="date" id="due_date" name="due_date" required>

                <button type="submit" name="assign_task">Submit Task</button>
            </form>
            <a href="admin_panel.php" class="back-button">Back</a>
        </div>
    </div>
</body>
</html>
