<?php
// Sākt sesiju, lai saglabātu lietotāja informāciju, piemēram, vārdu un e-pastu
session_start();

// Definēt mainīgos kļūdu ziņojumiem
$error_message = "";

// Mock lietotāja dati demonstrācijai (šī informācija nāktu no datu bāzes)
$_SESSION['name'] = isset($_SESSION['name']) ? $_SESSION['name'] : 'Gari Poter';
$_SESSION['email'] = isset($_SESSION['email']) ? $_SESSION['email'] : 'GarryPotter@hotmail.ru';
$stored_password = 'oldpassword'; // Mock saglabātā parole (reālajā gadījumā tā būtu hashēta)

// Funkcija, lai pārbaudītu pašreizējo paroli (aizstāt ar reālu datu bāzes pārbaudi)
function verify_current_password($current_password) {
    global $stored_password;
    return $current_password === $stored_password; // Reālā lietojumā jāizmanto paroles hashēšana
}

// Apstrādāt formu, ja tā ir iesniegta
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    // Atjaunināt vārdu, nepārbaudot paroli
    if (!empty($name)) {
        $_SESSION['name'] = $name; // Atjaunināt vārdu sesijā
    }

    // Pārbaudīt paroles, ja lietotājs vēlas to mainīt
    if (!empty($new_password) || !empty($confirm_password)) {
        if (!verify_current_password($current_password)) {
            $error_message = "Kļūda: Pašreizējā parole ir nepareiza.";
        } elseif ($new_password !== $confirm_password) {
            $error_message = "Kļūda: Jaunās paroles nesakrīt.";
        } else {
            // TODO: Atjaunināt paroli datu bāzē (hashēt jauno paroli)
            $stored_password = $new_password;
            // Nav nepieciešama pāradresācija, jo paliekam tajā pašā lapā
            header('Location: worker.php'); // Pāradresēt uz vadības paneli pēc veiksmīgas atjaunināšanas
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
            display: flex;
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: white;
            padding: 20px;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
        }
        .sidebar .logo {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .sidebar .menu {
            list-style: none;
            padding: 0;
        }
        .sidebar .menu li {
            margin-bottom: 15px;
        }
        .sidebar .menu a {
            color: white;
            text-decoration: none;
            font-weight: 500;
        }
        .sidebar .menu a:hover {
            text-decoration: underline;
        }
        .content {
            margin-left: 270px;
            padding: 20px;
            width: 100%;
        }
        h2 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        label {
            font-weight: 500;
            display: block;
            margin-top: 10px;
        }
        input {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        button {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }
        button:hover {
            background-color: #0056b3;
        }
        .error-message {
            color: red;
            margin-bottom: 20px;
        }
        .go-back {
            background-color: #ccc;
            padding: 10px 20px;
            border: none;
            border-radius: 20px;
            font-weight: 500;
            color: white;
            text-align: center;
            transition: background-color 0.3s;
            text-decoration: none;
        }
        .go-back:hover {
            background-color: #bbb;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo">TaskPro</div>
        <ul class="menu">
            <li><a href="assign_task.php">Assign Task</a></li>
            <li><a href="admin_panel.php">Manage Employees</a></li>
            <li><a href="track_task.php">Track Task</a></li>
            <li><a href="report.php" target="_blank">Reports</a></li>
            <li><a href="settings.php">Settings</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </div>

    <div class="content">
        <h2>User Settings</h2>

        <!-- Display error message -->
        <?php if (!empty($error_message)): ?>
            <p class="error-message"><?php echo $error_message; ?></p>
        <?php endif; ?>

        <form action="settings.php" method="post">
            <label for="name">Name:</label>
            <input type="text" id="name" name="name" value="<?php echo $_SESSION['name']; ?>">
            
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" value="<?php echo $_SESSION['email']; ?>">

            <label for="current_password">Current Password (required to change password):</label>
            <input type="password" id="current_password" name="current_password" placeholder="Enter current password">

            <label for="new_password">New Password:</label>
            <input type="password" id="new_password" name="new_password" placeholder="Enter new password">

            <label for="confirm_password">Confirm New Password:</label>
            <input type="password" id="confirm_password" name="confirm_password" placeholder="Re-enter new password">
            
            <button type="submit">Update Settings</button>
            <a href="worker.php" class="go-back">Go Back</a>
        </form>
    </div>
</body>
</html>