<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f7f7f7;
        }

        .reset-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 300px;
            text-align: center;
        }

        h2 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
        }

        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
            font-size: 14px;
            color: #555;
        }

        input[type="email"] {
            width: 100%;
            padding: 10px 10px; /* Added padding for left/right */
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box; /* Ensures padding is included in total width */
        }

        button {
            width: 100%;
            padding: 10px; /* Maintains existing padding */
            background-color: #1E90FF; /* Blue color */
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }

        button:hover {
            background-color: #0056b3; /* Darker blue on hover */
        }

        .message {
            color: green;
            margin-top: 15px;
            display: none; /* Hidden by default */
        }
    </style>
    <script>
        function sendResetLink(event) {
            event.preventDefault(); // Prevent the form from submitting

            // Simulate sending the email and display the message
            document.getElementById('resetMessage').style.display = 'block';

            // Redirect to the login page after 3 seconds
            setTimeout(function() {
                window.location.href = '/login'; // Change to your login route
            }, 3000);
        }
    </script>
</head>
<body>
    <div class="reset-container">
        <h2>Reset Your Password</h2>
        <form id="resetForm" onsubmit="sendResetLink(event)">
            <label for="resetEmail">Enter your email:</label>
            <input type="email" id="resetEmail" name="resetEmail" required>
            <button type="submit">Send Reset Link</button>
            <p class="message" id="resetMessage">Sent!</p>
        </form>
    </div>
</body>
</html>
