<?php
// Start session if it's not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Task Tracking - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        h1 {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }

        .task-grid {
            display: flex;
            gap: 20px;
        }

        .task-card {
            background-color: #e0e0e0;
            padding: 20px;
            border-radius: 10px;
            width: 100%;
        }

        .task-card h2 {
            font-size: 18px;
            font-weight: 500;
            margin-bottom: 10px;
        }

        .task-card p {
            font-size: 14px;
            margin-bottom: 10px;
            color: #555;
        }

        .progress-bar {
            height: 20px;
            background-color: #d3d3d3;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 10px;
        }

        .progress-bar .progress {
            height: 100%;
            background-color: #0000ff;
            border-radius: 10px;
            transition: width 0.3s;
        }

        .status {
            font-weight: bold;
            margin-bottom: 10px;
        }

        .task-info {
            display: flex;
            justify-content: space-between;
        }

        .urgency,
        .importance {
            font-size: 12px;
            font-weight: 500;
        }

        .back-button {
            background-color: blue;
            color: white;
            padding: 10px 20px;
            border-radius: 20px;
            text-decoration: none;
            font-weight: 500;
            border: none;
            cursor: pointer;
            display: inline-block;
            margin-top: 20px; /* Adds space between the tasks and the button */
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Task Tracking</h1>

        <div class="task-grid">
            <!-- Task 1 -->
            <div class="task-card">
                <h2>Task Title 1</h2>
                <p>Assigned to: Sarah Connor</p>
                <p class="status">Status: In Progress</p>
                <div class="progress-bar">
                    <div class="progress" style="width: 50%;"></div>
                </div>
                <div class="task-info">
                    <span class="urgency">Urgency: High</span>
                    <span class="importance">Importance: Critical</span>
                </div>
            </div>

            <!-- Task 2 -->
            <div class="task-card">
                <h2>Task Title 2</h2>
                <p>Assigned to: John Doe</p>
                <p class="status">Status: Completed</p>
                <div class="progress-bar">
                    <div class="progress" style="width: 100%;"></div>
                </div>
                <div class="task-info">
                    <span class="urgency">Urgency: Medium</span>
                    <span class="importance">Importance: High</span>
                </div>
            </div>

            <!-- Task 3 -->
            <div class="task-card">
                <h2>Task Title 3</h2>
                <p>Assigned to: Jane Smith</p>
                <p class="status">Status: Not Started</p>
                <div class="progress-bar">
                    <div class="progress" style="width: 0%;"></div>
                </div>
                <div class="task-info">
                    <span class="urgency">Urgency: Low</span>
                    <span class="importance">Importance: Medium</span>
                </div>
            </div>
        </div>

        <!-- Back Button -->
        <a href="worker.html" class="back-button">Back</a> <!-- The Back button that takes you to worker.html -->
    </div>
</body>
</html>
