<?php
// Sākt sesiju, lai saglabātu lietotāja informāciju, piemēram, vārdu un e-pastu
session_start();

// Definēt mainīgos kļūdu ziņojumiem
$error_message = "";

// Mock lietotāja dati demonstrācijai (šī informācija nāktu no datu bāzes)
$_SESSION['name'] = isset($_SESSION['name']) ? $_SESSION['name'] : 'Gari Poter';
$_SESSION['email'] = isset($_SESSION['email']) ? $_SESSION['email'] : 'GarryPotter@hotmail.ru';
$stored_password = 'oldpassword'; // Mock saglabātā parole (reālajā gadījumā tā būtu hashēta)

// Funkcija, lai pārbaudītu pašreizējo paroli (aizstāt ar reālu datu bāzes pārbaudi)
function verify_current_password($current_password) {
    global $stored_password;
    return $current_password === $stored_password; // Reālā lietojumā jāizmanto paroles hashēšana
}

// Apstrādāt formu, ja tā ir iesniegta
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    // Atjaunināt vārdu, nepārbaudot paroli
    if (!empty($name)) {
        $_SESSION['name'] = $name; // Atjaunināt vārdu sesijā
    }

    // Pārbaudīt paroles, ja lietotājs vēlas to mainīt
    if (!empty($new_password) || !empty($confirm_password)) {
        if (!verify_current_password($current_password)) {
            $error_message = "Kļūda: Pašreizējā parole ir nepareiza.";
        } elseif ($new_password !== $confirm_password) {
            $error_message = "Kļūda: Jaunās paroles nesakrīt.";
        } else {
            // TODO: Atjaunināt paroli datu bāzē (hashēt jauno paroli)
            $stored_password = $new_password;
            // Nav nepieciešama pāradresācija, jo paliekam tajā pašā lapā
            header('Location: worker.html'); // Pāradresēt uz vadības paneli pēc veiksmīgas atjaunināšanas
            exit;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .top-navigation {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .logo {
            font-size: 24px;
            font-weight: 700;
            color: #222;
            display: flex;
            align-items: center;
        }

        .menu-icon {
            margin-right: 10px;
        }

        .button-group {
            display: flex;
            gap: 10px;
        }

        .button-group button,
        .button-group a {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
            text-decoration: none; /* No underline */
            display: inline-block; /* Link looks like a button */
            transition: background-color 0.3s; /* Smooth transition */
        }

        .button-group a:hover,
        .button-group button:hover {
            background-color: #0056b3; /* Darker blue for hover effect */
        }

        .profile {
            display: flex;
            align-items: center;
        }

        .profile img {
            border-radius: 50%;
            width: 50px;
            height: 50px;
            margin-left: 10px;
        }

        .profile p {
            margin-right: 10px;
            color: #666;
            font-size: 14px;
        }

        h2 {
            font-size: 24px;
            margin-bottom: 20px;
        }

        label {
            font-weight: 500;
            display: block;
            margin-top: 10px;
        }

        input {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        button {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }

        button:hover {
            background-color: #0056b3;
        }

        .error-message {
            color: red;
            margin-bottom: 20px;
        }

        /* Stilizē "Go Back" pogu */
        .go-back {
            background-color: #ccc; /* Pelēka krāsa */
            padding: 10px 20px;
            border: none; /* No border */
            border-radius: 20px;
            font-weight: 500;
            color: white;
            text-align: center; /* Center text */
            transition: background-color 0.3s; /* Smooth transition */
            text-decoration: none; /* No underline */
        }

        .go-back:hover {
            background-color: #bbb; /* Tumšāka pelēka krāsa hover efektam */
        }
    </style>
</head>
<body>

    <div class="top-navigation">
        <div class="logo">
            <a href="worker.html" style="text-decoration: none; color: inherit;">
                <span class="menu-icon">☰</span>
                <span>TaskPro</span>
            </a>
        </div>
        <div class="button-group">
            <button>Assign Task</button>
            <button>Track Task</button>
            <button>Reports</button>
            <button>Settings</button>
            <a href="/logout">Logout</a>
        </div>
        <div class="profile">
            <p><?php echo $_SESSION['name']; ?> <br> <?php echo $_SESSION['email']; ?></p>
            <img src="https://shorturl.at/44zLJ" alt="Profile">
        </div>
    </div>

    <div class="container">
        <h2>User Settings</h2>

        <!-- Display error message -->
        <?php if (!empty($error_message)): ?>
            <p class="error-message"><?php echo $error_message; ?></p>
        <?php endif; ?>

        <form action="settings.php" method="post">
            <label for="name">Name:</label>
            <input type="text" id="name" name="name" value="<?php echo $_SESSION['name']; ?>">
            
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" value="<?php echo $_SESSION['email']; ?>">

            <label for="current_password">Current Password (required to change password):</label>
            <input type="password" id="current_password" name="current_password" placeholder="Enter current password">

            <label for="new_password">New Password:</label>
            <input type="password" id="new_password" name="new_password" placeholder="Enter new password">

            <label for="confirm_password">Confirm New Password:</label>
            <input type="password" id="confirm_password" name="confirm_password" placeholder="Re-enter new password">
            
            <button type="submit">Update Settings</button>
            <a href="worker.html" class="go-back">Go Back</a> <!-- Jaunā Go Back poga -->
        </form>
    </div>

</body>
</html>
