<?php
// Start session if it's not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports and Analytics - TaskMaster</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .logo {
            font-size: 24px;
            font-weight: 700;
            color: #222;
            display: flex;
            align-items: center;
        }

        h1 {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 20px;
        }

        /* Further increased spacing for reports section */
        .reports-section {
            display: grid;
            grid-template-columns: 1fr; /* Single column by default */
            gap: 100px; /* Very large gap between the charts */
            margin-bottom: 100px; /* Added large space at the bottom of reports section */
        }

        /* Media query for larger screens */
        @media(min-width: 768px) {
            .reports-section {
                grid-template-columns: 1fr 1fr; /* Two columns on larger screens */
                gap: 120px; /* Even more gap between the charts on larger screens */
            }
        }

        .chart {
            background-color: #e0e0e0;
            padding: 60px; /* Increased padding for the charts */
            border-radius: 10px;
            height: 450px; /* Increased height for larger spacing */
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            margin-bottom: 40px; /* Added margin to separate individual charts further */
        }

        .chart iframe {
            width: 100%;
            height: 100%;
            border: none;
            border-radius: 10px;
        }

        .chart img {
            width: 100%;
            height: auto;
            border-radius: 10px;
        }

        .back-button {
            background-color: blue;
            color: white;
            padding: 15px 30px;
            border-radius: 20px;
            text-decoration: none;
            font-weight: 500;
            border: none;
            cursor: pointer;
            display: inline-block;
            margin-top: 40px; /* Added more space above the back button */
        }
    </style>
</head>
<body>

    <div class="container">
        <header>
            <div class="logo">
                <span class="menu-icon">☰</span>
                <a href="worker.html" style="text-decoration: none; color: #222;">TaskMaster</a>
            </div>
            <div class="profile">
                <p><?php echo $_SESSION['name']; ?> <br> <?php echo $_SESSION['email']; ?></p>
            </div>
        </header>

        <h1>Reports and Data</h1>

        <div class="reports-section">
            <div class="chart">
                <p>Task Distribution</p>
                <img src="https://www.tableau.com/sites/default/files/2021-06/DataGlossary_Icons_Pie%20Chart.jpg" alt="Task Distribution Chart">
            </div>
            <div class="chart">
                <p>Task Completion Over Time</p>
                <img src="https://www150.statcan.gc.ca/edu/power-pouvoir/c-g/c-g05-4-1-eng.png" alt="Task Completion Over Time Chart">
            </div>
            <div class="chart" style="grid-column: span 2;">
                <p>Employee Performance Metrics</p>
                <img src="https://www.productplan.com/wp-content/uploads/2019/11/Gantt-chart.png" alt="Employee Performance Metrics Chart">
            </div>
            <!-- Embedded link using iframe -->
            <div class="chart" style="grid-column: span 2;">
                <p>External Task Analytics</p>
                <iframe src="https://wcs.smartdraw.com/chart/img/clustered-bar-chart.png?bn=15100111938" title="External Analytics"></iframe>
            </div>
        </div>

        <!-- Back Button -->
        <a href="worker.html" class="back-button">Back</a>
    </div>

</body>
</html>
