<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login to TaskPro</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f7f7f7;
            position: relative; /* Allow positioning of watermark */
        }

        .login-container, .reset-container {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 300px;
            text-align: center;
            z-index: 1; /* Ensure this is above the watermark */
        }

        h2 {
            margin-bottom: 20px;
            font-size: 24px;
            color: #333;
        }

        /* Add the following message class */
        .message {
            display: none; /* Initially hidden */
            color: green;  /* Change this to green */
            margin-top: 10px; /* Optional: adds space above the message */
        }

        label {
            display: block;
            margin-bottom: 5px;
            text-align: left;
            font-size: 14px;
            color: #555;
        }

        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 10px 10px; /* Added padding for left/right */
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box; /* Ensures padding is included in total width */
        }

        button {
            width: 100%;
            padding: 10px; /* Maintains existing padding */
            background-color: #1E90FF; /* Blue color */
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            margin-bottom: 10px; /* Space between buttons */
        }

        button:hover {
            background-color: #0056b3; /* Darker blue on hover */
        }

        p {
            margin-top: 15px;
            font-size: 14px;
        }

        p a {
            color: #1E90FF; /* Blue color */
            text-decoration: none;
        }

        p a:hover {
            text-decoration: underline;
        }

        /* Register link style */
        .register-link {
            display: block; /* Makes it behave like a block element */
            margin-top: 10px; /* Space above the link */
            color: #1E90FF; /* Blue color */
            text-decoration: none; /* No underline */
            font-size: 14px; /* Consistent font size */
        }

        .register-link:hover {
            text-decoration: underline; /* Underline on hover */
        }

        /* Watermark style */
        .watermark {
            position: absolute; /* Positioning relative to the body */
            top: 10px; /* Adjust as necessary */
            right: 10px; /* Adjust as necessary */
            font-size: 50px; /* Size of the watermark */
            color: rgba(0, 0, 0, 0.1); /* Light color for watermark */
            pointer-events: none; /* Prevent interactions with the watermark */
            user-select: none; /* Prevent text selection */
        }

        .hidden {
            display: none;
        }
    </style>
    <script>
        function showResetForm() {
            // Hide the login form
            document.getElementById('loginForm').classList.add('hidden');

            // Show the reset form
            document.getElementById('resetForm').classList.remove('hidden');
        }

        function sendResetLink(event) {
            event.preventDefault(); // Prevent the form from submitting

            // Simulate sending the email and display the message
            document.getElementById('resetMessage').style.display = 'block';

            // Redirect to the login page after 3 seconds
            setTimeout(function() {
                // Hide the reset form and show the login form again
                document.getElementById('resetForm').classList.add('hidden');
                document.getElementById('loginForm').classList.remove('hidden');
                document.getElementById('resetMessage').style.display = 'none';
            }, 3000);
        }
    </script>
</head>
<body>
    <div class="watermark">TaskPro</div> <!-- Watermark element -->
    <div class="login-container" id="loginForm">
        <h2>Login to TaskPro</h2>
        <?php if (isset($error)): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
        <form action="/login" method="POST">
            <label for="email">Email</label>
            <input type="email" id="email" name="email" required> <!-- Email field -->

            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">Login</button>
        </form>
        <p><a href="#" onclick="showResetForm()">Forgot your password?</a></p>
        <a href="/register" class="register-link">Register here</a> <!-- Styled Register Link -->
    </div>

    <div class="reset-container hidden" id="resetForm">
        <h2>Reset Your Password</h2>
        <form onsubmit="sendResetLink(event)">
            <label for="resetEmail">Enter your email:</label>
            <input type="email" id="resetEmail" name="resetEmail" required>
            <button type="submit">Send Reset Link</button>
            <p class="message" id="resetMessage">Sent!</p>
        </form>
    </div>
</body>
</html>
