<?php
// Pārbaudi, vai sesija jau ir aktīva
if (session_status() === PHP_SESSION_NONE) {
    session_start(); // Sāk sesiju tikai, ja tā nav jau aktīva
}

// Pārbaudi, vai sesija satur 'name' un 'email' informāciju
if (!isset($_SESSION['name'])) {
    $_SESSION['name'] = 'Gari Poter'; // Noklusējuma vārds, ja nav iestatīts
}
if (!isset($_SESSION['email'])) {
    $_SESSION['email'] = 'GarryPotter@hotmail.ru'; // Noklusējuma epasts, ja nav iestatīts
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assign Task - TaskPro</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f4f9;
            padding: 20px;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
        }

        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .logo {
            font-size: 24px;
            font-weight: 700;
            color: #222;
            display: flex;
            align-items: center;
        }

        .menu-icon {
            margin-right: 10px;
        }

        .back-button {
            background-color: blue;
            color: white;
            padding: 10px 20px;
            border-radius: 20px;
            text-decoration: none;
            font-weight: 500;
            border: none; /* Noņem pogas apmali */
            cursor: pointer; /* Rāda, ka tas ir pogu */
            display: inline-block; /* Pārliecinās, ka poga uzvedas kā bloku */
            margin-left: 10px; /* Attālums starp pogām */
        }

        .assign-task-form {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .assign-task-form label {
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
        }

        .assign-task-form input,
        .assign-task-form textarea,
        .assign-task-form select {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .priority-group {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
        }

        .priority-group label {
            margin-bottom: 0;
        }

        .assign-task-form button {
            padding: 10px 20px;
            background-color: #0000ff;
            color: white;
            border: none;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
        }

        .assign-task-form button:hover {
            background-color: #0056b3;
        }

        .upload-button {
            background-color: #0000ff;
            color: white;
            padding: 10px 20px;
            border-radius: 20px;
            cursor: pointer;
            font-weight: 500;
            display: inline-block;
            margin-top: 10px;
        }

        .upload-preview img {
            width: 100px;
            height: 100px;
            object-fit: cover;
            margin-right: 10px;
            border-radius: 10px;
        }
    </style>
</head>
<body>

    <div class="container">
        <header>
            <div class="logo">
                <span class="menu-icon">☰</span>
                <a href="worker.html" style="text-decoration: none; color: #222;">TaskPro</a>
            </div>
            <div class="profile">
                <p><?php echo $_SESSION['name']; ?> <br> <?php echo $_SESSION['email']; ?></p>
            </div>
        </header>

        <h2>Assign a New Task</h2>

        <div class="assign-task-form">
            <form action="worker.html" method="POST" enctype="multipart/form-data">
                <label for="task_name">Task Name</label>
                <input type="text" id="task_name" name="task_name" required>

                <label for="assign_employee">Assign to Employee</label>
                <input type="text" id="assign_employee" name="assign_employee" required>

                <label for="task_description">Task Description</label>
                <textarea id="task_description" name="task_description" rows="5" required></textarea>

                <label>Priority Level</label>
                <div class="priority-group">
                    <label><input type="radio" name="priority" value="Low" required> Low</label>
                    <label><input type="radio" name="priority" value="Medium"> Medium</label>
                    <label><input type="radio" name="priority" value="High"> High</label>
                </div>

                <label for="due_date">Due Date</label>
                <input type="date" id="due_date" name="due_date" required>

                <label for="task_photos">Task Photos/Checklists</label>
                <input type="file" id="task_photos" name="task_photos[]" multiple accept="image/*">
                <div class="upload-preview">
                    <!-- Previews for uploaded images will go here -->
                </div>

                <button type="submit">Submit Task</button>
                <a href="worker.html" class="back-button">Back</a> <!-- Poga blakus "Submit" pogai -->
            </form>
        </div>
    </div>

</body>
</html>
