<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load environment variables (comment this out if not using dotenv)
require_once __DIR__ . '/../vendor/autoload.php'; // Move this above to ensure all dependencies are loaded
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/../');
$dotenv->load();

session_start(); // Start session to manage login state

if (!isset($_SESSION)) {
    die('Session failed to start.');
}

// Include database configuration
require_once __DIR__ . '/../config/database.php';  // Only include once

// Basic routing
$requestUri = $_SERVER['REQUEST_URI'];

// Route to worker dashboard if logged in
if ($requestUri === '/workers') {
    // Ensure the user is logged in before showing the dashboard
    if (!isset($_SESSION['user_id'])) {
        header('Location: /login'); // Redirect to login if not authenticated
        exit;
    }
    include __DIR__ . '/../public/worker.html'; // Ensure this path is correct
} 
// Route to login page
else if ($requestUri === '/login') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $email = $_POST['email'];
        $password = $_POST['password'];

        // Fetch user from database
        $query = "SELECT * FROM users WHERE email = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();

        // Verify user exists and password is correct
        if ($user && password_verify($password, $user['password'])) {
            // Login successful - set session
            $_SESSION['user_id'] = $user['id'];
            header('Location: /workers'); // Redirect to worker dashboard
            exit;
        } else {
            $error = "Invalid email or password"; // Prepare to show this error in your login.php
        }
    }
    include __DIR__ . '/../public/login.php'; // Load the login HTML form
} 
// Route to register page
else if ($requestUri === '/register') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $username = $_POST['username'];
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT); // Hash the password

        // Check if the email is already registered
        $checkEmailQuery = "SELECT * FROM users WHERE email = ?";
        $stmt = $conn->prepare($checkEmailQuery);
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $error = "Email already registered!"; // Prepare to show this error in your register.php
        } else {
            // Insert new user
            $query = "INSERT INTO users (username, email, password) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($query);
            $stmt->bind_param('sss', $username, $email, $password);
            
            if ($stmt->execute()) {
                
                header('Location: /login'); // Redirect to login after successful registration
                exit;
            } else {
                $error = "Registration failed!"; // Prepare to show this error in your register.php
            }
        }
    }
    include __DIR__ . '/../public/register.php'; // Load the register HTML form
} 
// Logout route
else if ($requestUri === '/logout') {
    session_destroy(); // Destroy session and logout
    header('Location: /login');
    exit;
} 
// Default to 404 for unknown routes
else {
    echo "404 - Page not found. Route: " . $requestUri;
    exit;
}


