<?php
//Autors: Laura Kokina; PHP skripts veic grāmatas augšupielādi un saglabāšanu datubāzē;
//Veidots: 2024. gadā, Jaunākā versija

// Iestata HTTP galvenes, lai atbildētu JSON formātā un atļautu CORS
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Atļauj piekļuvi no jebkuras vietnes
header('Access-Control-Allow-Methods: POST'); // Atļauj tikai POST pieprasījumus
header('Access-Control-Allow-Headers: Content-Type'); // Atļauj noteiktas galvenes

// Pārbauda, vai pieprasījuma metode ir POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Pārbauda, vai ir saņemti nepieciešamie lauki (`title`, `author`, `photo`)
    if (!isset($_POST['title']) || !isset($_POST['author']) || !isset($_FILES['photo'])) {
        echo json_encode(['status' => 'error', 'message' => 'Missing title, author, or photo.']);
        exit; // Pārtrauc skripta izpildi, ja dati nav ievadīti
    }

    // Saglabā saņemtos datus mainīgajos
    $title = $_POST['title'];
    $author = $_POST['author'];

    // Norāda augšupielādes direktoriju attēlu glabāšanai
    $upload_dir = '../user_img/';

    // Nosaka faila paplašinājumu (mazie burti)
    $imageFileType = strtolower(pathinfo($upload_dir . basename($_FILES['photo']['name']), PATHINFO_EXTENSION));

    // Izveido faila ceļu ar unikālu nosaukumu (izmanto `tmp_name` un paplašinājumu)
    $target_file = $upload_dir . basename($_FILES['photo']['tmp_name']) . "." . $imageFileType;

    // Atļautie failu tipi (drošībai)
    $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];
    
    // Pārbauda, vai augšupielādētais fails ir atļautā formātā
    if (!in_array($imageFileType, $allowed_types)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid file type. Only JPG, JPEG, PNG & GIF allowed.']);
        exit; // Pārtrauc skripta izpildi, ja fails nav atļauts
    }

    // Pārvieto augšupielādēto failu uz galamērķa mapi
    if (move_uploaded_file($_FILES["photo"]["tmp_name"], $target_file)) {
        
        include 'connect.php'; // Iekļauj failu, kas izveido savienojumu ar datubāzi

        $liet_id = 0; // Lietotāja ID (pagaidām vienmēr 0, vajadzētu iegūt reālo lietotāju)

        // SQL vaicājums, lai ievietotu grāmatas datus datubāzē
        $sql = "
        INSERT INTO 
        liet_gramata (
            nosaukums, 
            autors, 
            attels, 
            liet_id
        )
        VALUES (
            ?, ?, ?, ?
        )
        ";

        // Sagatavo SQL vaicājumu, lai izvairītos no SQL injekcijām
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssi", $title, $author, $target_file, $liet_id);

        // Izpilda vaicājumu un pārbauda, vai tas bija veiksmīgs
        if ($stmt->execute()) {
            $last_id = $conn->insert_id; // Iegūst pēdējā ievietotā ieraksta ID
            echo json_encode([
                'status' => 'success', 
                'message' => 'Book added successfully.', 
                'id' => $last_id, 
                'title' => $title, 
                'author' => $author, 
                'photo' => $target_file
            ]);
        } else {
            // Ja SQL vaicājums neizdodas, atgriež kļūdas paziņojumu
            echo json_encode(['status' => 'error', 'message' => 'Database insert failed: ' . $stmt->error]);
        }

    } else {
        // Ja faila augšupielāde neizdodas, atgriež kļūdas paziņojumu
        echo json_encode(['status' => 'error', 'message' => 'File upload failed.']);
    }

} else {
    // Ja pieprasījuma metode nav POST, atgriež kļūdu
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}

?>
