// Autors: Laura Kokina; JS datne ar visām mājaslapas funkcijām;
// Veidots: 2024. gadā, Jaunākā versija

// Pārvalda navigāciju un uznirstošo logu pēc lapas ielādes
    let activeNavLink = null;
    var modal = null;
    var btn = null;
    var span = null;
    document.addEventListener('DOMContentLoaded',load);
 
// Funkcija jaunas grāmatas pievienošanas modulim 
function load(){ 
    // Ievada mainīgos
    var modal = document.getElementById("bookModal");
    var btn = document.getElementById("add-book-btn");
    var span = document.getElementsByClassName("close")[0];

    // Nospiežot pogu atveras modulis
    btn.onclick = function() {
      modal.style.display = "block";
    }

    // Nospiežot 'x' modulis aizveras
    span.onclick = function() {
      modal.style.display = "none";
    }

    // Nospiežot uz ekrāna ārpus moduļa, tas aizveras
    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
      }
    }
    // Apstrādā formas iesniegšanu, novēršot noklusējuma darbību un pievienojot jaunu grāmatu
    document.getElementById('bookForm').addEventListener('submit', function(event) {
        event.preventDefault(); // Neļauj formai tikt iesniegtai noklusējuma veidā
        addNewBook(); // Izsauc grāmatas pievienošanas funkciju
    });
}

// Funkcija jaunas grāmatas pievienošanai
function addNewBook() {
    // Iegūst formas vērtības
    const form = document.getElementById('bookForm');

    // Pamata validācija
    if (!title || !author || !photo) {
      alert('Please fill in all fields.');
      return; // Apstādina darbību, ja kāds lauks ir neaizpildīts
    }

    // Izveido datu objektu, ko nosūtīt ar pieprasījumu
    let bookData = new FormData(form);
    // Pārsūta datus uz serveri izmantojot fetch
    fetch('php/add_book.php', {
      method: 'POST',
      headers: {
       },
      body: bookData, 
    })
  .then(response => response.json()) // Pieņemot, ka serveris atbild ar JSON formātu
  .then(data => {
    if (data.status === 'success') {
      alert('Book added successfully!');
      // Pēc izvēles aizvērt modālo logu vai atiestatīt formu
      document.getElementById('bookForm').reset();  // Notīra formu
      document.getElementById('bookModal').style.display = 'none';  // Aizver modālo logu
    } else {
      alert('Error: ' + data.message);
    }
  })
  .catch(error => {
    console.error('Error:', error);
    alert('An error occurred while adding the book.');
  });
}

// Funkcija, kas apstrādā attēla priekšskatījumu
function previewImage(event) {
    const file = event.target.files[0]; // Iegūst augšupielādēto failu
    const reader = new FileReader();

    reader.onload = function(e) {
      const imagePreview = document.getElementById("imagePreview");
      imagePreview.src = e.target.result; // Iestata attēla priekšskatījumu uz augšupielādēto failu
      document.getElementById("imagePreviewContainer").style.display = "block"; // Parāda priekšskatījuma konteineri
    };

    if (file) {
      reader.readAsDataURL(file); // Izlasa failu kā datu URL
    }
  }

// Funkcija, kas pārslēdz logus un izceļ pašreizējo aktīvo navigācijas saiti
function showTab(tabId, element) {
    var tabs = document.querySelectorAll('.tab-content');
    tabs.forEach(function (tab) {
        tab.classList.remove('active');
    });
    document.getElementById(tabId).classList.add('active');

    // Izceļ pašreizējo aktīvo navigācijas saiti
    if (activeNavLink) {
        activeNavLink.classList.remove('active-nav');
    }
    element.classList.add('active-nav');
    activeNavLink = element;
}

// Funkcija, kas paslēpj grāmatas detaļas rekomendāciju logā
function toggleDetails(listItem) {
    var details = listItem.querySelector('.book-details');
    if (details.classList.contains('hidden')) {
        details.classList.remove('hidden');
    } else {
        details.classList.add('hidden');
    }
}

//no index.html
function gramata(){
   fetch("./php/data.php")
    .then(source => source.json())
    .then(data => gramatas(data));
}
function gramatas(data){
 const list=document.getElementById("book-list"); 
 list.innerHTML="";
    for (let row of data) {
       list.innerHTML+= `       
<li class="recommendation" data-title="${row['nosaukums']}" data-author="${row['autors']}" onclick="toggleDetails(this)">
    <img src="./img/${row['attels']}" alt="${row['nosaukums']}" class="book-cover">
    <div class="book-info">
        <span class="book-title"><b>${row['nosaukums']}</b> by </span>${row['autors']}
    </div>
    <div class="book-details hidden">
        <p class="book-year">Year: ${row['izd_gads']}</p>
        <p class="book-description">${row['apraksts']}</p>
        <button
            class="btn" 
            onclick="
                addToReadingList(this);
                event.stopPropagation();
            ";
        >Add to To-Read List</button>
        <button 
            class="btn" 
            onclick="
                moveToRead(this);
                event.stopPropagation();
            ";
        >Mark as Read</button>
    </div>
</li>
`
    } 
}

// Funkcija grāmatas pievienošanai "To-Read" sarakstam
function addToReadingList(item) {//title, author, year, description) {
    let title=item.parentNode.parentNode.getElementsByClassName('book-title')[0].innerText;//.split("by")[0].trim();
    const toReadList = document.getElementById('to-read-list');
    const existingBooks = toReadList.querySelectorAll('.book-title');
     // Novērš dublikātu pievienošanu grāmatu sarakstā
    for (let i = 0; i < existingBooks.length; i++) {
        if (existingBooks[i].textContent === title) {
            alert(`"${title}" is already in your To-Read list.`);
            return;
        }
    }

    // Izveido jaunu saraksta vienumu "To-Read" sarakstam
    const newListItem = document.createElement('li');
    // Iegūst informāciju no grāmatu saraksta
    newListItem.innerHTML =item.parentNode.parentNode.innerHTML;
    toReadList.appendChild(newListItem);
    // Iegūst "Add to To-Read list" pogu
    let reading=toReadList.getElementsByTagName("button")[0];
    // Noņem pogu
    reading.remove();
    alert(`"${title}" has been added to your To-Read list!`);
}

// Funkcija grāmatas pārvietošanai uz "Read" sarakstu
function moveToRead(item) {
    let title = item.parentNode.parentNode.getElementsByClassName('book-title')[0].innerText; // Get the book title
    const readList = document.getElementById('read-list');
    const toReadList = document.getElementById('to-read-list');
    
    // Novērš dublikātu pievienošanu "Read" sarakstā
    const existingBooks = readList.querySelectorAll('.book-title');
    for (let i = 0; i < existingBooks.length; i++) {
        if (existingBooks[i].textContent === title) {
            alert(`"${title}" is already in your Read list.`);
            return;
        }
    }

    // Pārbauda, vai grāmata eksistē "To-Read" sarakstā, un, ja tā tiek atrasta, izdzēš to
    const toReadBooks = toReadList.querySelectorAll('li');
    toReadBooks.forEach(book => {
        const bookTitle = book.querySelector('.book-title').textContent;
        if (bookTitle === title) {
            toReadList.removeChild(book);
        }
    });

    // Pievieno grāmatu "Read" sarakstam
    const newListItem = document.createElement('li');
    newListItem.innerHTML = item.parentNode.parentNode.innerHTML;
    readList.appendChild(newListItem);

    // Noņem visas pogas "Read" sarakstā
    const buttons = newListItem.querySelectorAll('button');
    buttons.forEach(button => button.remove());

    alert(`"${title}" has been marked as Read!`);
}

// Izņem grāmatu no "To-Read" saraksta, pēc grāmatu pārvietošanas uz "Read" sarakstu
function removeFromToRead(title) {
    const toReadList = document.getElementById('to-read-list');
    const books = toReadList.querySelectorAll('li');

    books.forEach(book => {
        const bookTitle = book.querySelector('.book-title').textContent;
        if (bookTitle === title) {
            toReadList.removeChild(book);
        }
    });
    title.remove();
}

// Atver iestatījumu moduli
function openSettingsModal() {
    document.getElementById('settings-modal').style.display = 'flex';
}

// Aizver iestatījumu moduli
function closeSettingsModal() {
    document.getElementById('settings-modal').style.display = 'none';
}

// Nakts režīms
function toggleNightMode() {
    const nightModeEnabled = document.getElementById('night-mode-toggle').checked;
    const themeStyle = document.getElementById('theme-style');
    if (nightModeEnabled) {
        themeStyle.setAttribute('href', 'css/night.css');
        localStorage.setItem('theme', 'night');
    } else {
        themeStyle.setAttribute('href', 'css/index.css');
        localStorage.setItem('theme', 'day');
    }
}

// Load saved theme from localStorage
function loadSavedTheme() {
    const savedTheme = localStorage.getItem('theme');
    const nightModeToggle = document.getElementById('night-mode-toggle');
    if (savedTheme === 'night') {
        document.getElementById('theme-style').setAttribute('href', 'css/night.css');
        nightModeToggle.checked = true;
    }
}

// Ielādē saglabāto tēmu no localStorage
document.addEventListener('DOMContentLoaded', loadSavedTheme);

// Meklēšanas josla
function searchBooks() {
    const input = document.getElementById('searchInput').value.toLowerCase();
    const bookList = document.getElementById('book-list');
    const books = bookList.getElementsByClassName('recommendation');

    Array.from(books).forEach(book => {
        const title = book.getAttribute('data-title').toLowerCase();
        const author = book.getAttribute('data-author').toLowerCase();

        // Rāda vai slēpj grāmatas atbilstoši meklēšanas ievadei
        if (title.includes(input) || author.includes(input)) {
            book.style.display = '';
        } else {
            book.style.display = 'none';
        }
    });

    // Function to handle form submission and add new book
    function addNewBook_() {
      // Get the form values
      const title = document.getElementById('title').value;
      const author = document.getElementById('author').value;
      const publicationDate = document.getElementById('publicationDate').value;
      const description = document.getElementById('description').value;
      const photo = document.getElementById('photo').value;

      // Basic validation (can be extended as needed)
      if (!title || !author || !publicationDate || !description) {
        alert('Please fill in all fields.');
        return; // Stop if any field is empty
      }

      // Create a data object to send with the request
      const bookData = {
        title: title,
        author: author,
        publicationDate: publicationDate,
        description: description,
        photo: photo
      };

      // Send the data to the server using fetch
      fetch('add_book.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json', // Send data as JSON
        },
        body: JSON.stringify(bookData) // Convert data to JSON
      })
      .then(response => response.json()) // Assuming the server responds with JSON
      .then(data => {
        if (data.status === 'success') {
          alert('Book added successfully!');
          // Optionally close the modal or reset the form
          document.getElementById('bookForm').reset();  // Clear the form
          document.getElementById('bookModal').style.display = 'none';  // Close the modal
        } else {
          alert('Error: ' + data.message);
        }
      })
      .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while adding the book.');
      });
    }

    // Event listener for form submission (to prevent default behavior)
    document.getElementById('bookForm').addEventListener('submit', function(event) {
      event.preventDefault(); // Prevent the form from submitting the default way
      addNewBook(); // Call the function to add the book
    });
}