<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');
 // $input = json_decode(file_get_contents('php://input'), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate required fields
    // / if (isset($input['title']) && isset($input['author']) && isset($input['photo'])) {
    if (!isset($_POST['title']) || !isset($_POST['author']) || !isset($_FILES['photo'])) {
        echo json_encode(['status' => 'error', 'message' => 'Missing title, author, or photo.']);
        exit;
    }

    $title = $_POST['title'];
    $author = $_POST['author'];

    // Process file upload
    $upload_dir = '../user_img/';
    $imageFileType = strtolower(pathinfo($upload_dir.basename($_FILES['photo']['name']),PATHINFO_EXTENSION));
    $target_file = $upload_dir . basename($_FILES['photo']['tmp_name']).".".$imageFileType;
    // Allowed file types
    $allowed_types = ['jpg', 'jpeg', 'png', 'gif'];
    if (!in_array($imageFileType, $allowed_types)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid file type. Only JPG, JPEG, PNG & GIF allowed.']);
        exit;
    }

    // Move uploaded file to destination folder
   if (move_uploaded_file($_FILES["photo"]["tmp_name"], $target_file)) {
        
        include 'connect.php'; // Ensure this file properly connects to your DB
        $liet_id = 0; // Placeholder value, adjust if necessary

        // Save book details into database
        $sql = "
        INSERT INTO 
        liet_gramata (
            nosaukums, 
            autors, 
            attels, 
            liet_id
        )
        VALUES (
            ?,
            ?,
            ?,
            ?
        )
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssi", $title, $author, $target_file, $liet_id);
        if ($stmt->execute()) {
            $last_id = $conn->insert_id;
            echo json_encode(['status' => 'success', 'message' => 'Book added successfully.', 'id' => $last_id]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Database insert failed: ' . $stmt->error]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'File upload failed.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
