<?php
include 'connect.php';

$email = $_POST['email'];
$password = $_POST['password'];

$response = [];

// Prepare SQL statement to find the user by email
$sql = "SELECT parole FROM lietotajs WHERE epasts = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    // User found, now fetch the hashed password
    $stmt->bind_result($hashed_password);
    $stmt->fetch();

    // Verify the entered password with the hashed password in the database
    if (password_verify($password, $hashed_password)) {
        $response['success'] = true;
        $response['message'] = "Login successful!";
    } else {
        $response['success'] = false;
        $response['message'] = "Invalid password.";
    }
} else {
    // User not found
    $response['success'] = false;
    $response['message'] = "No account found with that email.";
}

echo json_encode($response);

$stmt->close();
$conn->close();
?>
