  // Track active navigation link
    let activeNavLink = null;

    var modal = null;
    var btn = null;
    var span = null;
    document.addEventListener('DOMContentLoaded',load);
 
function load(){ 
    // Get the modal and button
    modal = document.getElementById("bookModal");
    btn = document.getElementById("add-book-btn");
    span = document.getElementsByClassName("close")[0];

    // Open the modal when the button is clicked
    btn.onclick = function() {
      modal.style.display = "block";
    }

    // Close the modal when the 'x' is clicked
    span.onclick = function() {
      modal.style.display = "none";
    }

    // Close the modal if clicked outside of it
    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
      }
    }
    // Event listener for form submission (to prevent default behavior)
    document.getElementById('bookForm').addEventListener('submit', function(event) {
        event.preventDefault(); // Prevent the form from submitting the default way
        addNewBook(); // Call the function to add the book
    });
}
// Function to handle form submission and add new book
function addNewBook() {
  // Get the form values
  const title = document.getElementById('title').value;
  const author = document.getElementById('author').value;
  const publicationDate = document.getElementById('publicationDate').value;
  const description = document.getElementById('description').value;
  const photo = document.getElementById('photo').value;

  // Basic validation (can be extended as needed)
  if (!title || !author || !publicationDate || !description) {
    alert('Please fill in all fields.');
    return; // Stop if any field is empty
  }

  // Create a data object to send with the request
  const bookData = {
    title: title,
    author: author,
    publicationDate: publicationDate,
    description: description,
    photo: photo
  };

  // Send the data to the server using fetch
  fetch('add_book.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json', // Send data as JSON
    },
    body: JSON.stringify(bookData) // Convert data to JSON
  })
  .then(response => response.json()) // Assuming the server responds with JSON
  .then(data => {
    if (data.status === 'success') {
      alert('Book added successfully!');
      // Optionally close the modal or reset the form
      document.getElementById('bookForm').reset();  // Clear the form
      document.getElementById('bookModal').style.display = 'none';  // Close the modal
    } else {
      alert('Error: ' + data.message);
    }
  })
  .catch(error => {
    console.error('Error:', error);
    alert('An error occurred while adding the book.');
  });
}

function showTab(tabId, element) {
    var tabs = document.querySelectorAll('.tab-content');
    tabs.forEach(function (tab) {
        tab.classList.remove('active');
    });
    document.getElementById(tabId).classList.add('active');

    // Highlight the current active nav link
    if (activeNavLink) {
        activeNavLink.classList.remove('active-nav');
    }
    element.classList.add('active-nav');
    activeNavLink = element;
}

// Toggle book details in recommendations
function toggleDetails(listItem) {
    var details = listItem.querySelector('.book-details');
    if (details.classList.contains('hidden')) {
        details.classList.remove('hidden');
    } else {
        details.classList.add('hidden');
    }
}

//no index.html
function gramata(){
   fetch("./php/data.php")
    .then(source => source.json())
    .then(data => gramatas(data));
}
function gramatas(data){
 const list=document.getElementById("book-list"); 
 list.innerHTML="";
    for (let row of data) {
       list.innerHTML+= `       
<li class="recommendation" data-title="${row['nosaukums']}" data-author="${row['autors']}" onclick="toggleDetails(this)">
    <img src="./img/${row['attels']}" alt="${row['nosaukums']}" class="book-cover">
    <div class="book-info">
        <span class="book-title"><b>${row['nosaukums']}</b> by </span>${row['autors']}
    </div>
    <div class="book-details hidden">
        <p class="book-year">Year: ${row['izd_gads']}</p>
        <p class="book-description">${row['apraksts']}</p>
        <button
            class="btn" 
            onclick="
                addToReadingList(this);
                event.stopPropagation();
            ";
        >Add to To-Read List</button>
        <button 
            class="btn" 
            onclick="
                moveToRead(this);
                event.stopPropagation();
            ";
        >Mark as Read</button>
    </div>
</li>
`
    } 
}

// Function to add book to To-Read list
function addToReadingList(item) {//title, author, year, description) {
    let title=item.parentNode.parentNode.getElementsByClassName('book-title')[0].innerText;//.split("by")[0].trim();
    const toReadList = document.getElementById('to-read-list');
    const existingBooks = toReadList.querySelectorAll('.book-title');
     // Prevent adding duplicate books to the list
    for (let i = 0; i < existingBooks.length; i++) {
        if (existingBooks[i].textContent === title) {
            alert(`"${title}" is already in your To-Read list.`);
            return;
        }
    }

    // Create a new list item for the To-Read list
    const newListItem = document.createElement('li');
    //Get info from look list
    newListItem.innerHTML =item.parentNode.parentNode.innerHTML;
    toReadList.appendChild(newListItem);
    //Get To-Read buton 
    let reading=toReadList.getElementsByTagName("button")[0];
    //Remove To-Read button
    reading.remove();
    alert(`"${title}" has been added to your To-Read list!`);
}

// Function to move book from To-Read to Books Read
function moveToRead(item){//(title, author, year, description) {
    let title=item.parentNode.parentNode.getElementsByClassName('book-title')[0].innerText;//.split("by")[0].trim();
    const readList = document.getElementById('read-list');
    const newListItem = document.createElement('li');
       // Prevent adding duplicate books to the list
       const existingBooks = readList.querySelectorAll('.book-title');
    for (let i = 0; i < existingBooks.length; i++) {
        if (existingBooks[i].textContent === title) {
            alert(`"${title}" is already in your To-Read list.`);
            return;
        }
    }
    
    newListItem.innerHTML =item.parentNode.parentNode.innerHTML;
    readList.appendChild(newListItem);
    let read=newListItem.getElementsByTagName("button");
    //alert(read.length);
    removeFromToRead(item.parentNode.parentNode);
    for(let i=read.length-1;i>-1;i--){
        read[i].remove();
    }

    alert(`"${title}" has been marked as Read!`);
}

// Remove book from To-Read list after moving to Books Read
function removeFromToRead(title) {
    /*const toReadList = document.getElementById('to-read-list');
    const books = toReadList.querySelectorAll('li');

    books.forEach(book => {
        const bookTitle = book.querySelector('.book-title').textContent;
        if (bookTitle === title) {
            toReadList.removeChild(book);
        }
    });
    */
    title.remove();
}

// Open Settings Modal
function openSettingsModal() {
    document.getElementById('settings-modal').style.display = 'flex';
}

// Close Settings Modal
function closeSettingsModal() {
    document.getElementById('settings-modal').style.display = 'none';
}


// Toggle Night Mode
function toggleNightMode() {
    const nightModeEnabled = document.getElementById('night-mode-toggle').checked;
    const themeStyle = document.getElementById('theme-style');
    if (nightModeEnabled) {
        themeStyle.setAttribute('href', 'css/night.css');
        localStorage.setItem('theme', 'night');
    } else {
        themeStyle.setAttribute('href', 'css/index.css');
        localStorage.setItem('theme', 'day');
    }
}

// Load saved theme from localStorage
function loadSavedTheme() {
    const savedTheme = localStorage.getItem('theme');
    const nightModeToggle = document.getElementById('night-mode-toggle');
    if (savedTheme === 'night') {
        document.getElementById('theme-style').setAttribute('href', 'css/night.css');
        nightModeToggle.checked = true;
    }
}

// Initialize theme on page load
document.addEventListener('DOMContentLoaded', loadSavedTheme);

// Search books by title or author
function searchBooks() {
    const input = document.getElementById('searchInput').value.toLowerCase();
    const bookList = document.getElementById('book-list');
    const books = bookList.getElementsByClassName('recommendation');

    Array.from(books).forEach(book => {
        const title = book.getAttribute('data-title').toLowerCase();
        const author = book.getAttribute('data-author').toLowerCase();

        // Show or hide books based on search input
        if (title.includes(input) || author.includes(input)) {
            book.style.display = '';
        } else {
            book.style.display = 'none';
        }
    });
    
     // Get the modal and button
    var modal = document.getElementById("bookModal");
    var btn = document.getElementById("add-book-btn");
    var span = document.getElementsByClassName("close")[0];

    // Open the modal when the button is clicked
    btn.onclick = function() {
      modal.style.display = "block";
    }

    // Close the modal when the 'x' is clicked
    span.onclick = function() {
      modal.style.display = "none";
    }

    // Close the modal if clicked outside of it
    window.onclick = function(event) {
      if (event.target == modal) {
        modal.style.display = "none";
      }
    }

    // Function to handle form submission and add new book
    function addNewBook() {
      // Get the form values
      const title = document.getElementById('title').value;
      const author = document.getElementById('author').value;
      const publicationDate = document.getElementById('publicationDate').value;
      const description = document.getElementById('description').value;
      const photo = document.getElementById('photo').value;

      // Basic validation (can be extended as needed)
      if (!title || !author || !publicationDate || !description) {
        alert('Please fill in all fields.');
        return; // Stop if any field is empty
      }

      // Create a data object to send with the request
      const bookData = {
        title: title,
        author: author,
        publicationDate: publicationDate,
        description: description,
        photo: photo
      };

      // Send the data to the server using fetch
      fetch('add_book.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json', // Send data as JSON
        },
        body: JSON.stringify(bookData) // Convert data to JSON
      })
      .then(response => response.json()) // Assuming the server responds with JSON
      .then(data => {
        if (data.status === 'success') {
          alert('Book added successfully!');
          // Optionally close the modal or reset the form
          document.getElementById('bookForm').reset();  // Clear the form
          document.getElementById('bookModal').style.display = 'none';  // Close the modal
        } else {
          alert('Error: ' + data.message);
        }
      })
      .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while adding the book.');
      });
    }

    // Event listener for form submission (to prevent default behavior)
    document.getElementById('bookForm').addEventListener('submit', function(event) {
      event.preventDefault(); // Prevent the form from submitting the default way
      addNewBook(); // Call the function to add the book
    });
}



