<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Book Tracker</title>
    <link rel="stylesheet" href="../css/index.css" id="theme-style">
</head>
<body>

<?php include 'connect.php'; ?>

<body>
    <header>
        <h1>Book Tracker</h1>
        <p>Manage, track, and discover new books!</p>
    </header>

    <nav>
        <ul>
            <li><a href="#" onclick="showTab('recommendations', this)">Recommendations</a></li>
            <li><a href="#" onclick="showTab('to-read', this)">Books To-Read</a></li>
            <li><a href="#" onclick="showTab('read', this)">Books Read</a></li>
            <li><a href="#" onclick="showTab('profile', this)">Profile</a></li>
        </ul>
    </nav>

    <div class="container">
        <!-- Recommendations section -->
        <section id="recommendations" class="tab-content active">
            <h2>Recommended Books</h2>

            <!-- Search Bar -->
            <div class="right-aligned">
                <input type="text" id="searchInput" class="search-bar" placeholder="Search by title or author..." onkeyup="searchBooks()">
            </div>

            <ul class="recommendations-list" id="book-list">

            <?php
    // Fetch data from the database
    $sql = "SELECT * FROM gramatas";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {

        while($row = $result->fetch_assoc()) {
            ?>
            <li class="recommendation" data-title="<?php echo  htmlspecialchars($row['nosaukums']) ?>" data-author="Aldous Huxley" onclick="toggleDetails(this)">
                    <img src="../img/<?php echo  htmlspecialchars($row['attels']) ?>" alt="Brave New World cover" class="book-cover">
                    <div class="book-info">
                        <span class="book-title"><b><?php echo  htmlspecialchars($row['nosaukums']) ?></b> by </span><?php echo  htmlspecialchars($row['autors']) ?>
                    </div>
                    <div class="book-details hidden">
                        <p class="book-year">Year: <?php echo  htmlspecialchars($row['izd_gads']) ?></p>
                        <p class="book-description"><?php echo  htmlspecialchars($row['apraksts']) ?></p>
                        <button class="add-to-read-btn" onclick="addToReadingList('', 'Aldous Huxley', '1932', 'A dystopian novel...'); event.stopPropagation();">Add to To-Read List</button>
                    </div>
                </li>
                <?php
        }
    } else {
        echo "<p>No books found.</p>";
    }
    $conn->close();
    ?>

            </ul>
        </section>

        <!-- Books To-Read section -->
        <section id="to-read" class="tab-content">
            <h2>Books To-Read</h2>

            <div id="books-container"></div>


            <!-- Search Bar -->
            <div class="right-aligned">
                <input type="text" id="searchInput" class="search-bar" placeholder="Search by title or author..." onkeyup="searchBooks()">
            </div>

            <ul id="to-read-list"></ul>
        </section>

        <!-- Books Read section -->
        <section id="read" class="tab-content">
            <h2>Books You ve Read</h2>

    -->        <!-- Search Bar 
            <div class="right-aligned">
                <input type="text" id="searchInput" class="search-bar" placeholder="Search by title or author..." onkeyup="searchBooks()">
            </div>
            
            <ul id="read-list"></ul>
        </section>

        <!-- Profile section -->
        <section id="profile" class="tab-content">
            <h2>Your Profile</h2>
            <p>Track your reading progress, manage books, and discover new recommendations based on your interests.</p>
            <!-- Settings Button -->
            <button class="settings-btn" onclick="openSettingsModal()">Settings</button>
        </section>

        <!-- Modal for Settings -->
        <div id="settings-modal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeSettingsModal()">&times;</span>
                <h2>Settings</h2>
                <div class="settings">
                    <h3>Manage Your Preferences</h3>
                    <ul>
                        <li><label><input type="checkbox" id="night-mode-toggle" onchange="toggleNightMode()"> Night Mode</label></li>
                        <li>
                            <label for="language-select">Language:</label>
                            <select id="language-select">
                                <option value="en">English</option>
                                <option value="fr">French</option>
                                <option value="es">Spanish</option>
                            </select>
                        </li>
                        <li><label><input type="checkbox"> Enable Notifications</label></li>
                        <li>Manage Account Settings</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    
    <footer>
    <p>&copy; 2024 Your reading platform. All Rights Reserved.</p>
    </footer>
    
</div>

</body>
</html>
