// Track active navigation link
let activeNavLink = null;

function showTab(tabId, element) {
    var tabs = document.querySelectorAll('.tab-content');
    tabs.forEach(function (tab) {
        tab.classList.remove('active');
    });
    document.getElementById(tabId).classList.add('active');

    // Highlight the current active nav link
    if (activeNavLink) {
        activeNavLink.classList.remove('active-nav');
    }
    element.classList.add('active-nav');
    activeNavLink = element;
}

// Toggle book details in recommendations
function toggleDetails(listItem) {
    var details = listItem.querySelector('.book-details');
    if (details.classList.contains('hidden')) {
        details.classList.remove('hidden');
    } else {
        details.classList.add('hidden');
    }
}

// Open Settings Modal
function openSettingsModal() {
    document.getElementById('settings-modal').style.display = 'flex';
}

// Close Settings Modal
function closeSettingsModal() {
    document.getElementById('settings-modal').style.display = 'none';
}

// Function to add book to To-Read list
function addToReadingList(title, author, year, description) {
    const toReadList = document.getElementById('to-read-list');
    const existingBooks = toReadList.querySelectorAll('.book-title');

    // Prevent adding duplicate books to the list
    for (let i = 0; i < existingBooks.length; i++) {
        if (existingBooks[i].textContent === title) {
            alert(`"${title}" is already in your To-Read list.`);
            return;
        }
    }

    // Create a new list item for the To-Read list
    const newListItem = document.createElement('li');
    newListItem.innerHTML = `
        <span class="book-title">${title}</span> by ${author} (${year})
        <p class="book-description">${description}</p>
        <button onclick="moveToRead('${title}', '${author}', '${year}', '${description}')">Mark as Read</button>
    `;
    toReadList.appendChild(newListItem);

    alert(`"${title}" has been added to your To-Read list!`);
}

// Function to move book from To-Read to Books Read
function moveToRead(title, author, year, description) {
    const readList = document.getElementById('read-list');
    const newListItem = document.createElement('li');

    newListItem.innerHTML = `
        <span class="book-title">${title}</span> by ${author} (${year})
        <p class="book-description">${description}</p>
    `;

    readList.appendChild(newListItem);
    removeFromToRead(title);
    alert(`"${title}" has been marked as Read!`);
}

// Remove book from To-Read list after moving to Books Read
function removeFromToRead(title) {
    const toReadList = document.getElementById('to-read-list');
    const books = toReadList.querySelectorAll('li');

    books.forEach(book => {
        const bookTitle = book.querySelector('.book-title').textContent;
        if (bookTitle === title) {
            toReadList.removeChild(book);
        }
    });
}

// Toggle Night Mode
function toggleNightMode() {
    const nightModeEnabled = document.getElementById('night-mode-toggle').checked;
    const themeStyle = document.getElementById('theme-style');
    if (nightModeEnabled) {
        themeStyle.setAttribute('href', 'css/night.css');
        localStorage.setItem('theme', 'night');
    } else {
        themeStyle.setAttribute('href', 'css/index.css');
        localStorage.setItem('theme', 'day');
    }
}

// Load saved theme from localStorage
function loadSavedTheme() {
    const savedTheme = localStorage.getItem('theme');
    const nightModeToggle = document.getElementById('night-mode-toggle');
    if (savedTheme === 'night') {
        document.getElementById('theme-style').setAttribute('href', 'css/night.css');
        nightModeToggle.checked = true;
    }
}

// Initialize theme on page load
document.addEventListener('DOMContentLoaded', loadSavedTheme);

// Search books by title or author
function searchBooks() {
    const input = document.getElementById('searchInput').value.toLowerCase();
    const bookList = document.getElementById('book-list');
    const books = bookList.getElementsByClassName('recommendation');

    Array.from(books).forEach(book => {
        const title = book.getAttribute('data-title').toLowerCase();
        const author = book.getAttribute('data-author').toLowerCase();

        // Show or hide books based on search input
        if (title.includes(input) || author.includes(input)) {
            book.style.display = '';
        } else {
            book.style.display = 'none';
        }
    });
}



//no index.html
  function gramata(){
   fetch("./php/data.php")
    .then(source => source.json())
    .then(data => gramatas(data));
}
function gramatas(data){
 const list=document.getElementById("book-list"); 
 list.innerHTML="";
    for (let row of data) {
       list.innerHTML+= `       
<li class="recommendation" data-title="${row['nosaukums']}" data-author="${row['autors']}" onclick="toggleDetails(this)">
    <img src="./img/${row['attels']}" alt="${row['nosaukums']}" class="book-cover">
    <div class="book-info">
        <span class="book-title"><b>${row['nosaukums']}</b> by </span>${row['autors']}
    </div>
    <div class="book-details hidden">
        <p class="book-year">Year: ${row['izd_gads']}</p>
        <p class="book-description">${row['apraksts']}</p>
        <button 
            class="add-to-read-btn" 
            onclick="
            addToReadingList(
                '${row['nosaukums']}',
                '${row['autors']}',
                '${row['izd_gads']}',
               // "${row['apraksts'].replaceAll(/'/g,"").replaceAll(/"/g,"")}"
               ''
            );
                event.stopPropagation()";
        >Add to To-Read List</button>
    </div>
</li>
`
    } 
}