<?php
// Atļauj CORS pieprasījumus, ja tas ir nepieciešams jūsu sistēmai
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Datubāzes savienojuma parametri
$host = "localhost"; // Datubāzes serveris
$dbname = "kinkyai"; // Datubāzes nosaukums
$username = "root"; // Lietotājvārds
$password = ""; // Parole

try {
    // Izveido PDO savienojumu ar datubāzi
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Nolasa ievades datus no pieprasījuma ķermeņa
    $input = json_decode(file_get_contents("php://input"), true);

    // Pieprasa lietotāja ievades laukus
    $name = $input['name'] ?? '';
    $email = $input['email'] ?? '';
    $password = $input['password'] ?? '';

    // Pārbauda, vai visi lauki ir aizpildīti
    if (empty($name) || empty($email) || empty($password)) {
        echo json_encode(["error" => "Visi lauki ir obligāti jāaizpilda"]);
        http_response_code(400);
        exit;
    }

    // Pārbauda, vai e-pasta adrese jau eksistē
    $stmt = $conn->prepare("SELECT * FROM users WHERE email = :email");
    $stmt->bindParam(":email", $email);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        echo json_encode(["error" => "Šī e-pasta adrese jau ir reģistrēta"]);
        http_response_code(400);
        exit;
    }

    // Šifrē lietotāja paroli, lai uzlabotu drošību
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // Sagatavo SQL vaicājumu lietotāja reģistrācijai
    $stmt = $conn->prepare("INSERT INTO users (name, email, password) VALUES (:name, :email, :password)");
    $stmt->bindParam(":name", $name);
    $stmt->bindParam(":email", $email);
    $stmt->bindParam(":password", $hashedPassword);
    $stmt->execute();

    // Veiksmīga reģistrācija
    echo json_encode(["message" => "Reģistrācija veiksmīga"]);
    http_response_code(201);
} catch (PDOException $e) {
    // Kļūdas apstrāde, ja rodas problēma ar datubāzi
    echo json_encode(["error" => "Datubāzes kļūda: " . $e->getMessage()]);
    http_response_code(500);
}
?>
