<?php
// Izveido savienojumu ar datubāzi
$conn = new mysqli("localhost", "root", "", "kinkyai");

// Pārbauda savienojumu
if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Neizdevās izveidot savienojumu ar datubāzi"]));
}

// Nolasa POST datus
$content = isset($_POST['content']) ? $_POST['content'] : '';
$sender = isset($_POST['sender']) ? $_POST['sender'] : '';

// Pārbauda, vai lauki nav tukši
if (empty($content) || empty($sender)) {
    echo json_encode(["status" => "error", "message" => "Saturs un sūtītājs nevar būt tukši"]);
    exit();
}

// Sagatavo un izpilda SQL vaicājumu
$stmt = $conn->prepare("INSERT INTO messages (content, sender) VALUES (?, ?)");
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Neizdevās sagatavot SQL vaicājumu"]);
    exit();
}
$stmt->bind_param("ss", $content, $sender);

// Izpilda vaicājumu un pārbauda rezultātu
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Ziņojums veiksmīgi saglabāts"]);
} else {
    echo json_encode(["status" => "error", "message" => "Neizdevās saglabāt ziņojumu"]);
}

// Aizver vaicājumu un savienojumu
$stmt->close();
$conn->close();
?>
