<?php
// Atļauj CORS pieprasījumus un nosaka atbildes tipu kā JSON
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Datubāzes savienojuma parametri
$host = "localhost";
$dbname = "kinkyai";
$username = "root";
$password = "";

try {
    // Izveido PDO savienojumu ar datubāzi
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Nolasa POST datus no pieprasījuma ķermeņa
    $input = json_decode(file_get_contents("php://input"), true);

    // Pieprasa lietotāja e-pastu un paroli
    $email = $input['email'] ?? '';
    $password = $input['password'] ?? '';

    // Pārbauda, vai e-pasts un parole ir aizpildīti
    if (empty($email) || empty($password)) {
        http_response_code(400);
        echo json_encode(["error" => "E-pasts un parole ir obligāti"]);
        exit;
    }

    // Pārbauda, vai lietotājs ar šo e-pastu eksistē
    $stmt = $conn->prepare("SELECT * FROM users WHERE email = :email");
    $stmt->bindParam(":email", $email);
    $stmt->execute();

    if ($stmt->rowCount() === 0) {
        http_response_code(401);
        echo json_encode(["error" => "Nepareizs e-pasts vai parole"]);
        exit;
    }

    // Iegūst lietotāja datus no datubāzes
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Pārbauda, vai parole ir pareiza
    if (password_verify($password, $user['password'])) {
        http_response_code(200);
        echo json_encode(["message" => "Pieteikšanās veiksmīga"]);
    } else {
        http_response_code(401);
        echo json_encode(["error" => "Nepareizs e-pasts vai parole"]);
    }
} catch (PDOException $e) {
    // Kļūdu apstrāde, ja rodas problēma ar datubāzi
    http_response_code(500);
    echo json_encode(["error" => "Datubāzes kļūda: " . $e->getMessage()]);
}
?>
