// Atver modālo logu
function openModal() {
    // Iestata modālā loga displeja stilu uz "flex", lai to parādītu
    document.getElementById("deleteModal").style.display = "flex";
}

// Aizver modālo logu
function closeModal() {
    // Iestata modālā loga displeja stilu uz "none", lai to paslēptu
    document.getElementById("deleteModal").style.display = "none";
}

// Augšupielādē profila bildi
function uploadProfilePicture() {
    // Atrod profila bildes ievades lauku un attēla elementu
    const fileInput = document.getElementById('profilePictureInput');
    const profilePicture = document.getElementById('profilePicture');

    // Pārbauda, vai ir izvēlēts fails
    if (fileInput.files && fileInput.files[0]) {
        // Izveido FileReader objektu, lai nolasītu failu
        const reader = new FileReader();

        // Definē, kas notiek, kad fails ir nolasīts
        reader.onload = function (e) {
            // Iestata profila bildes avotu uz nolasīto datu URL
            profilePicture.src = e.target.result;
        };

        // Sāk faila nolasīšanu kā datu URL
        reader.readAsDataURL(fileInput.files[0]);
    }
}

// Pārslēdz nakts režīmu, noklikšķinot uz slēdža
document.getElementById('nightModeSwitch').addEventListener('click', function () {
    // Pārslēdz "dark-mode" klasi uz body elementa
    document.body.classList.toggle('dark-mode');

    // Pārbauda, vai nakts režīms ir ieslēgts
    const isDarkMode = document.body.classList.contains('dark-mode');

    // Saglabā nakts režīma iestatījumu localStorage
    localStorage.setItem('nightMode', isDarkMode ? 'enabled' : 'disabled');
});

// Ielādē saglabāto nakts režīma iestatījumu, kad lapa ir ielādēta
window.addEventListener('load', function () {
    // Pārbauda, vai localStorage satur nakts režīma iestatījumu
    if (localStorage.getItem('nightMode') === 'enabled') {
        // Pievieno "dark-mode" klasi body elementam
        document.body.classList.add('dark-mode');
    }
});