// Pievieno notikumu pieteikšanās formai, lai apstrādātu tās iesniegšanu
document.getElementById("loginForm").addEventListener("submit", async (event) => {
    event.preventDefault(); // Novērš formas noklusēto iesniegšanas darbību

    // Iegūst e-pasta un paroles vērtības no ievades laukiem
    const email = document.getElementById("email").value.trim();
    const password = document.getElementById("password").value.trim();

    try {
        // Nosūta pieteikšanās pieprasījumu uz PHP backend
        const response = await fetch("php/login.php", {
            method: "POST", // Izmanto POST metodi
            headers: {
                "Content-Type": "application/json", // Nosaka, ka dati tiek nosūtīti JSON formātā
            },
            body: JSON.stringify({ email, password }), // Pārvērš datus JSON formātā
        });

        // Iegūst atbildi no servera un pārvērš to JSON formātā
        const result = await response.json();

        // Pārbauda, vai atbilde ir veiksmīga
        if (response.ok) {
            // Ja pieteikšanās ir veiksmīga, novirza lietotāju uz sākumlapu
            window.location.href = "landing.html"; // Novirzīšana uz sākumlapu
        } else {
            // Ja pieteikšanās neizdevās, parāda kļūdas paziņojumu
            const errorPopup = document.createElement("div");
            errorPopup.classList.add("error-popup"); // Pievieno klasi kļūdas paziņojumam
            errorPopup.innerText = result.error || "Invalid email or password. Please try again."; // Iestata kļūdas tekstu
            document.body.appendChild(errorPopup); // Pievieno kļūdas paziņojumu lapai

            // Automātiski noņem kļūdas paziņojumu pēc 3 sekundēm
            setTimeout(() => {
                errorPopup.remove();
            }, 3000);
        }
    } catch (error) {
        // Ja notiek kļūda, izvada to konsolē
        console.error("Error during login:", error);

        // Parāda vispārēju kļūdas paziņojumu
        const errorPopup = document.createElement("div");
        errorPopup.classList.add("error-popup"); // Pievieno klasi kļūdas paziņojumam
        errorPopup.innerText = "An error occurred. Please try again."; // Iestata kļūdas tekstu
        document.body.appendChild(errorPopup); // Pievieno kļūdas paziņojumu lapai

        // Automātiski noņem kļūdas paziņojumu pēc 3 sekundēm
        setTimeout(() => {
            errorPopup.remove();
        }, 3000);
    }
});

// Paroles redzamības pārslēgšana
const togglePassword = document.getElementById("togglePassword"); // Atrod paroles redzamības pārslēgšanas ikonu
const passwordInput = document.getElementById("password"); // Atrod paroles ievades lauku

// Pievieno notikumu, lai pārslēgtu paroles redzamību
togglePassword.addEventListener("click", () => {
  // Pārbauda, vai paroles lauks pašlaik ir slēpts, un pārslēdz tā tipu
  const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
  passwordInput.setAttribute("type", type);

  // Pārslēdz ikonu starp "fa-eye" un "fa-eye-slash", nemainot izkārtojumu
  togglePassword.querySelector("i").classList.toggle("fa-eye");
  togglePassword.querySelector("i").classList.toggle("fa-eye-slash");

  // Saglabā un atjauno kursora pozīciju pēc pārslēgšanas
  const cursorPosition = passwordInput.selectionStart; // Iegūst pašreizējo kursora pozīciju
  passwordInput.value = passwordInput.value; // Atjauno lauka vērtību, lai aktivizētu kursora atjaunināšanu
  passwordInput.setSelectionRange(cursorPosition, cursorPosition); // Atjauno kursora pozīciju
});