// Pārbauda, vai visa dokumenta struktūra ir ielādēta, pirms izpilda kodu
document.addEventListener("DOMContentLoaded", () => {
    // Atrod sānjoslu un parallax slāņus
    const sidebar = document.querySelector(".sidebar");
    const parallaxLayers = document.querySelectorAll(".parallax-layer");
    // Atrod visus satura blokus (content sections)
    const floatingBoxes = document.querySelectorAll(".content-section");
    // Atrod ritināšanas pogu
    const scrollButton = document.querySelector("#scroll-down-arrow");
    // Izvēlas otro satura bloku (indekss 1)
    const secondBox = floatingBoxes[1];

    // Mainīgais, lai izsekotu pēdējo ritināšanas pozīciju
    let lastScrollPosition = 0;

    // Funkcija, kas apstrādā ritināšanas notikumus
    const handleScroll = () => {
        // Iegūst pašreizējo ritināšanas pozīciju
        const currentScrollPosition = window.scrollY;

        // Ja lietotājs ritina uz leju, paslēpj sānjoslu
        if (currentScrollPosition > 0) {
            sidebar.classList.add("hidden");
        } else {
            // Ja lietotājs ritina uz augšu vai ir lapas augšdaļā, parāda sānjoslu
            sidebar.classList.remove("hidden");
        }

        // Pielieto parallax efektu
        applyParallax();
        // Apstrādā satura bloku animācijas
        handleBoxAnimations();
        // Pārbauda un atjauno ritināšanas pogas redzamību
        handleButtonVisibility();
    };

    // Funkcija, kas pielieto parallax efektu
    const applyParallax = () => {
        // Iegūst pašreizējo ritināšanas pozīciju
        const scrollPosition = window.scrollY;

        // Iterē cauri visiem parallax slāņiem
        parallaxLayers.forEach((layer) => {
            // Iegūst slāņa ātrumu no "data-speed" atribūta
            const speed = parseFloat(layer.getAttribute("data-speed"));
            // Aprēķina slāņa nobīdi, pamatojoties uz ritināšanas pozīciju un ātrumu
            const yOffset = scrollPosition * speed;
            // Pielieto transformāciju, lai pārvietotu slāni
            layer.style.transform = `translateY(${yOffset}px)`;
        });
    };

    // Funkcija, kas apstrādā satura bloku animācijas
    const handleBoxAnimations = () => {
        // Iterē cauri visiem satura blokiem
        floatingBoxes.forEach((box) => {
            // Iegūst bloka augšējo un apakšējo robežu attiecībā pret ekrānu
            const boxTop = box.getBoundingClientRect().top;
            const boxBottom = box.getBoundingClientRect().bottom;

            // Ja bloks ir redzams ekrānā, pievieno klasi "visible"
            if (boxTop < window.innerHeight && boxBottom > 0) {
                box.classList.add("visible");
            } else {
                // Ja bloks nav redzams, noņem klasi "visible"
                box.classList.remove("visible");
            }
        });
    };

    // Funkcija, kas pārbauda un atjauno ritināšanas pogas redzamību
    const handleButtonVisibility = () => {
        // Pārbauda, vai otrais satura bloks eksistē
        if (secondBox) {
            // Iegūst otrā satura bloka apakšējo robežu
            const secondBoxRect = secondBox.getBoundingClientRect();
            const secondBoxEnd = secondBoxRect.bottom;

            // Ja otrais satura bloks ir pilnībā redzams ekrānā, paslēpj ritināšanas pogu
            if (secondBoxEnd <= window.innerHeight) {
                scrollButton.classList.add("hidden");
            } else {
                // Ja otrais satura bloks nav pilnībā redzams, parāda ritināšanas pogu
                scrollButton.classList.remove("hidden");
            }
        }
    };

    // Pievieno ritināšanas pogai klikšķa notikumu
    if (scrollButton) {
        scrollButton.addEventListener("click", () => {
            // Ritina lapu uz leju par vienu ekrāna augstumu
            window.scrollBy({ top: window.innerHeight, behavior: "smooth" });
        });
    }

    // Pievieno ritināšanas notikumu, lai izsauktu handleScroll funkciju
    window.addEventListener("scroll", handleScroll);

    // Sākotnējais funkcijas izsaukums, lai pareizi iestatītu elementus
    handleScroll();
});