const apiUrl = "http://localhost/kvalifikacija_html/first_page/php";

// Pagaida, kamēr lapa tiek ielādēta, un pēc tam ielādē čata vēsturi
document.addEventListener("DOMContentLoaded", async () => {
    await loadHistory();
});

async function loadHistory() {
    try {
        // Pieprasa čata vēsturi no servera
        const response = await axios.get(`${apiUrl}/getChatHistory.php`);
        const history = response.data;

        // Atlasa satura konteineru
        const contentContainer = document.querySelector(".content");
        contentContainer.innerHTML = ""; // Notīra iepriekšējo saturu

        // Aizpilda satura konteineru ar saņemto vēsturi
        history.forEach((item) => {
            const itemDiv = document.createElement("div");
            itemDiv.className = "generated-item";

            itemDiv.innerHTML = `
                <span class="content-text">${item.content}</span>
                <button class="edit-button" onclick="enableEdit(this)">Rediģēt</button>
                <a href="chat_history.html?chat=${encodeURIComponent(item.content)}">
                    <img src="images/arrow.png" class="arrow-icon" alt="Skatīt čatu">
                </a>
            `;

            contentContainer.appendChild(itemDiv);
        });
    } catch (error) {
        console.error("Kļūda, ielādējot vēsturi:", error);
    }
}

// Aktivizē rediģēšanas režīmu
function enableEdit(button) {
    const itemContainer = button.closest(".generated-item");
    const contentText = itemContainer.querySelector(".content-text");
    const input = document.createElement("input");
    input.type = "text";
    input.value = contentText.textContent;
    input.className = "edit-input";

    contentText.replaceWith(input);
    input.focus();

    input.addEventListener("blur", () => saveEdit(input));
    input.addEventListener("keypress", (e) => {
        if (e.key === "Enter") saveEdit(input);
    });
}

// Saglabā rediģēto saturu
function saveEdit(input) {
    const contentText = document.createElement("span");
    contentText.className = "content-text";
    contentText.textContent = input.value;
    input.replaceWith(contentText);
}
