const toggleNewPassword = document.getElementById("toggleNewPassword");
const newPasswordInput = document.getElementById("newPassword");

// Pievieno klausītāju pogai, lai pārslēgtu jauno paroli starp redzamu un slēptu
toggleNewPassword.addEventListener("click", () => {
    const type = newPasswordInput.getAttribute("type") === "password" ? "text" : "password";
    newPasswordInput.setAttribute("type", type);

    // Maina ikonu atkarībā no paroles redzamības statusa
    toggleNewPassword.querySelector("i").classList.toggle("fa-eye");
    toggleNewPassword.querySelector("i").classList.toggle("fa-eye-slash");
});

// Klausās jaunas paroles ievadi un pārbauda prasību atbilstību
newPasswordInput.addEventListener("input", (event) => {
    const password = event.target.value;

    const hasUppercase = /[A-Z]/.test(password);
    updateRequirement("uppercase-check", hasUppercase);

    const hasNumber = /[0-9]/.test(password);
    updateRequirement("number-check", hasNumber);

    const hasSpecialChar = /[!@#$%^&*]/.test(password);
    updateRequirement("special-char-check", hasSpecialChar);

    const isLongEnough = password.length >= 8;
    updateRequirement("length-check", isLongEnough);
});

// Atjaunina paroles prasību statusu
function updateRequirement(requirementId, isValid) {
    const requirementElement = document.getElementById(requirementId);
    const icon = requirementElement.querySelector(".icon");

    if (isValid) {
        icon.textContent = "✔"; // Ja prasība izpildīta
        requirementElement.classList.add("valid");
        requirementElement.classList.remove("invalid");
    } else {
        icon.textContent = "✘"; // Ja prasība nav izpildīta
        requirementElement.classList.add("invalid");
        requirementElement.classList.remove("valid");
    }
}

// Apstrādā paroles atiestatīšanas formu
document.getElementById("forgotPasswordForm").addEventListener("submit", async (event) => {
    event.preventDefault();

    const email = document.getElementById("email").value.trim();
    const oldPassword = document.getElementById("oldPassword").value.trim();
    const newPassword = document.getElementById("newPassword").value.trim();

    // Pārbauda, vai parole atbilst visām prasībām
    const hasUppercase = /[A-Z]/.test(newPassword);
    const hasNumber = /[0-9]/.test(newPassword);
    const hasSpecialChar = /[!@#$%^&*]/.test(newPassword);
    const isLongEnough = newPassword.length >= 8;

    if (!hasUppercase || !hasNumber || !hasSpecialChar || !isLongEnough) {
        showPopup("Lūdzu, izpildiet visas paroles prasības pirms atiestatīšanas.", "error");
        return;
    }

    try {
        // Nosūta pieprasījumu uz serveri paroles maiņai
        const response = await fetch("php/resetpassword.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({ email, oldPassword, newPassword }),
        });

        const result = await response.json();

        if (response.ok) {
            showPopup(result.message || "Parole veiksmīgi atiestatīta.", "success");
        } else {
            showPopup(result.error || "Paroles atiestatīšana neizdevās. Mēģiniet vēlreiz.", "error");
        }
    } catch (error) {
        console.error("Kļūda atiestatot paroli:", error);
        showPopup("Radās kļūda. Mēģiniet vēlreiz.", "error");
    }
});

// Funkcija, kas parāda uznirstošo paziņojumu
function showPopup(message, type) {
    const popup = document.createElement("div");
    popup.classList.add("popup", type);
    popup.innerText = message;
    document.body.appendChild(popup);

    setTimeout(() => {
        popup.remove();
    }, 3000);
}
