// Valodas dati
const languageData = {
    lv: {
        title: "Ķīmiskā tīrīšana",
        loginTitle: "Autorizējieties",
        welcomeTitle: "Sveicināti mūsu ķīmiskās tīrīšanas uzņēmumā!",
        welcomeText: "Izvēlieties kādu no sadaļām.",
        logout: "Jūs esat izgājis.",
        shortPasswordError: "Jūs ievadījāt pārāk īsu paroli.",
        changeLang: "Mainīt valodu",
        changePassword: "Mainīt paroli",
        contacts: "Kontakti",
        services: "Pakalpojumi"
    },
    ru: {
        title: "Химическая чистка",
        loginTitle: "Авторизуйтесь",
        welcomeTitle: "Добро пожаловать в нашу компанию по химической чистке!",
        welcomeText: "Выберите один из разделов.",
        logout: "Вы вышли из системы.",
        shortPasswordError: "Вы ввели слишком короткий пароль.",
        changeLang: "Изменить язык",
        changePassword: "Сменить пароль",
        contacts: "Контакты",
        services: "Услуги"
    },
    en: {
        title: "Chemical Cleaning",
        loginTitle: "Login",
        welcomeTitle: "Welcome to our chemical cleaning company!",
        welcomeText: "Choose one of the sections.",
        logout: "You have logged out.",
        shortPasswordError: "You entered a password that is too short.",
        changeLang: "Change Language",
        changePassword: "Change Password",
        contacts: "Contacts",
        services: "Services"
    }
};

// Valodas maiņa
function changeLanguage(lang) {
    document.getElementById("login-title").innerText = languageData[lang].loginTitle;
    document.getElementById("welcome-title").innerText = languageData[lang].welcomeTitle;
    document.getElementById("welcome-text").innerText = languageData[lang].welcomeText;
    document.getElementById("change-password").innerText = languageData[lang].changePassword;
    document.getElementById("change-lang").innerText = languageData[lang].changeLang;
    document.getElementById("contacts").innerText = languageData[lang].contacts;
    document.getElementById("services").innerText = languageData[lang].services;
}

// Autorizācijas funkcionalitāte
document.getElementById("login-btn").addEventListener("click", function() {
    const username = document.getElementById("username").value;
    const password = document.getElementById("password").value;
    const errorMessage = document.getElementById("password-error");

    errorMessage.innerText = ''; // Notīra iepriekšējās kļūdas ziņas

    if (password.length < 7) {
        errorMessage.innerText = languageData.lv.shortPasswordError; // Mainīt uz atbilstošo valodu
        return;
    }

    // Iestata lietotāja segvārdu un paslēpj autorizācijas logu
    document.getElementById("user-nickname").innerText = username;
    document.getElementById("login-container").style.display = "none"; // Paslēpj autorizācijas logu
    document.getElementById("dropdown-content").style.display = "block"; // Atver izvēlni
});

// Valodas izvēles pogas
const langButtons = document.querySelectorAll(".lang-btn");
langButtons.forEach(button => {
    button.addEventListener("click", function() {
        const lang = button.getAttribute("data-lang");
        changeLanguage(lang);
    });
});

// Navigācija
document.getElementById("home").addEventListener("click", function() {
    const descriptionHTML = `
        <h1 id='welcome-title'>Sveicināti mūsu ķīmiskās tīrīšanas uzņēmumā!</h1>
        <p id='welcome-text'>Ķīmiskā tīrītava veiksmīgi strādā kopš 2008.gada, apkalpojot gan fiziskas, gan juridiskas personas Rīgā un Rīgas rajonā. Uzņēmumā ir nodarbināti profesionāli darbinieki ar daudzu gadu pieredzi. Mēs strādājam tikai ar Eiropā ražotām profesionālām iekārtām. Darbinieku profesionalitāte un augstās klases iekārtas dod mums iespēju nodrošināt nevainojamu kvalitāti par saprātīgām cenām.</p>
        <h2>Mērķi</h2>
        <ul>
            <li>Sniedzot profesionālus ķīmiskās tīrīšanas pakalpojumus.</li>
            <li>Informējot klientus par pakalpojumu cenām un iespējām.</li>
            <li>Veicinot apmierinātību ar sniegtajiem pakalpojumiem.</li>
            <li>Atbalstot ilgtspējīgas prakses ķīmiskajā tīrīšanā.</li>
        </ul>
    `;
    document.getElementById("content").innerHTML = descriptionHTML;
    closeSidebar(); // Aizver hamburger izvēlni
});


document.getElementById("services").addEventListener("click", function() {
    // Pievienojam pakalpojumu sarakstu
    const servicesHTML = `
        <h1>Pakalpojumi</h1>
        <ul>
            <li>Ķīmiskā tīrīšana automašīnām</li>
            <li>Rupju audumu tīrīšana</li>
            <li>Matraču tīrīšana</li>
            <li>Paklāju ķīmiskā tīrīšana</li>
            <li>Segumu tīrīšana</li>
            <li>Automašīnu salons</li>
            <li>Īpašās ķīmiskās tīrīšanas metodes</li>
            <li>Pakalpojumi uzņēmumiem</li>
            <li>Salona atjaunošana</li>
            <li>Vēl daudzi citi pakalpojumi</li>
        </ul>
    `;
    document.getElementById("content").innerHTML = servicesHTML;
    closeSidebar(); // Aizver hamburger izvēlni
});

document.getElementById("about").addEventListener("click", function() {
    const aboutHTML = `
    <h1>Rekvizīti</h1>
    <ul>
    <li>Uzņēmuma nosaukums: Ķīmiskā Tīrīšana SIA</li>
    <li>Reģistrācijas numurs: 123456789</li>
    <li>Adrese: Rīga, Latvija,Alberta iela 13</li>
    <li>Tālrunis: +371 12345678</li>
    <li>E-pasts: info@kimiskatirsana.lv</li>
    </ul>
    `;
    document.getElementById("content").innerHTML = aboutHTML;
    closeSidebar(); // Aizver hamburger izvēlni
});

document.getElementById("pricing").addEventListener("click", function() {
    const pricingHTML = `
    <h1>Cenas</h1>
    <ul>
    <li>Ķīmiskā tīrīšana automašīnām: <strong>€50 - €100</strong></li>
        <li>Rupju audumu tīrīšana: <strong>€30 - €60</strong></li>
        <li>Matraču tīrīšana: <strong>€40 - €80</strong></li>
        <li>Paklāju ķīmiskā tīrīšana: <strong>€20 - €50</strong></li>
        <li>Segumu tīrīšana: <strong>€25 - €70</strong></li>
        <li>Automašīnu salons: <strong>€30 - €80</strong></li>
        <li>Īpašās ķīmiskās tīrīšanas metodes: <strong>€60 - €120</strong></li>
        <li>Pakalpojumi uzņēmumiem: <strong>€100 - €300</strong></li>
        <li>Salona atjaunošana: <strong>€70 - €150</strong></li>
    </ul>
    `;
    document.getElementById("content").innerHTML = pricingHTML;
    closeSidebar(); // Aizver hamburger izvēlni
});

document.getElementById("contacts").addEventListener("click", function() {
    const contactsHTML = `
    <h1>Kontakti</h1>
    <p><strong>Uzņēmuma nosaukums:</strong> Ķīmiskās Tīrīšanas Serviss</p>
    <p><strong>Adrese:</strong> Alberta iela 13, Rīga, Latvija, LV-1010</p>
    <p><strong>Tālrunis:</strong> <a href="tel:+37112345678">(+371) 1234 5678</a></p>
    <p><strong>E-pasts:</strong> <a href="mailto:info@kimiskatirina.lv">info@kimiskatirina.lv</a></p>
    <p><strong>Darba laiks:</strong></p>
    <ul>
    <li>Pirmdiena – Piektdiena: 9:00 – 18:00</li>
        <li>Sestdiena: 10:00 – 16:00</li>
        <li>Svētdiena: Slēgts</li>
    </ul>

    <h2>Mūsu lokācija</h2>
    <iframe 
        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2175.379993031151!2d24.107531367178773!3d56.959423134531505!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x46eecfc5af943003%3A0x1214a65892f44038!2sAlberta%20iela%2013%2C%20Centra%20rajons%2C%20R%C4%ABga%2C%20LV-1010!5e0!3m2!1sru!2slv!4v1727625218592!5m2!1sru!2slv" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade" 
        width="600" 
        height="450" 
        style="border:0;" 
        allowfullscreen="" 
        loading="lazy">
    </iframe>
    `;
    document.getElementById("content").innerHTML = contactsHTML;
    closeSidebar(); // Aizver hamburger izvēlni
});

// Poga "Iziet no konta"
document.getElementById("logout-btn").addEventListener("click", function() {
    document.getElementById("user-nickname").innerText = 'Lietotājs'; // Atjauno noklusējumu
    document.getElementById("login-container").style.display = "flex"; // Atgriež autorizācijas logu
    document.getElementById("dropdown-content").style.display = "none"; // Aizver izvēlni
});

// Lietotāja segvārda klikšķa notikums
document.getElementById("user-nickname").addEventListener("click", function() {
    const dropdown = document.getElementById("dropdown-content");
    dropdown.style.display = dropdown.style.display === "block" ? "none" : "block"; // Parāda/slēpj izvēlni
});

// Mainīt valodu
document.getElementById("change-lang").addEventListener("click", function() {
    const langOptions = document.getElementById("lang-options");
    langOptions.style.display = langOptions.style.display === "block" ? "none" : "block"; // Parāda/slēpj valodas izvēli
});

// Mainīt paroli
document.getElementById("change-password").addEventListener("click", function() {
    alert("Paroles maiņas funkcija vēl nav pieejama.");
});

// Hamburger izvēlnes atvēršana/ aizvēršana
function toggleSidebar() {
    const sidebar = document.getElementById("sidebar");
    sidebar.classList.toggle("active"); // Pievieno/novāc "active" klasi
}

// X poga izvēlnes aizvēršanai
document.getElementById("close-btn").addEventListener("click", function() {
    closeSidebar();
});

// Funkcija, lai aizvērtu hamburger izvēlni
function closeSidebar() {
    document.getElementById("sidebar").classList.remove("active");
}

// Pievieno notikumu, lai aizvērtu hamburger izvēlni, kad uzspiež uz kādas no pogām
const sidebarButtons = document.querySelectorAll(".sidebar a");
sidebarButtons.forEach(button => {
    button.addEventListener("click", function() {
        closeSidebar();
    });
});
 