<?php
function pievienot_statistiku($savienojums, $lietotaja_id, $tips, $rezultats) {
    // SQL vaicājums datu ievietošanai tabulā "statistika"
    $sql = "INSERT INTO statistika (lietotaja_id, tips, rezultats, datums) VALUES (?, ?, ?, CURDATE())";
    // Sagatavo SQL vaicājumu
    $stmt = $savienojums->prepare($sql);
    // Pievieno parametrus vaicājumam
    $stmt->bind_param("isd", $lietotaja_id, $tips, $rezultats);
    // Izpilda vaicājumu
    $stmt->execute();
    // Aizver sagatavoto vaicājumu
    $stmt->close();
}
?>
<?php
function iegut_statistiku($savienojums, $lietotaja_id, $tips, $no_datuma, $lidz_datuma) {
    // SQL vaicājums, lai atlasītu rezultātus un datumus tabulā "statistika"
    $sql = "SELECT datums, rezultats FROM statistika WHERE lietotaja_id = ? AND tips = ? AND datums BETWEEN ? AND ?";
    // Sagatavo SQL vaicājumu
    $stmt = $savienojums->prepare($sql);
    // Pievieno parametrus vaicājumam
    $stmt->bind_param("isss", $lietotaja_id, $tips, $no_datuma, $lidz_datuma);
    // Izpilda vaicājumu
    $stmt->execute();
    // Iegūst vaicājuma rezultātu
    $rezultats = $stmt->get_result();
    // Pārvērš rezultātus asociatīvā masīvā
    $dati = $rezultats->fetch_all(MYSQLI_ASSOC);
    // Aizver sagatavoto vaicājumu
    $stmt->close();
    // Atgriež iegūtos datus
    return $dati;
}
?>
