<?php
require 'datubaze.php'; // Datubāzes savienojuma fails
require 'statistika_funkcijas.php'; // Funkcijas statistikas pārvaldībai

$lietotaja_id = $_SESSION['lietotaja_id']; // Lietotāja ID no sesijas
$no_datuma = $_GET['sakumDatums'] ?? date('Y-m-01'); // Noklusējums: mēneša sākums
$lidz_datuma = $_GET['beiguDatums'] ?? date('Y-m-d'); // Noklusējums: šodien

// Iegūt statistikas datus
$merkesanas_dati = iegut_statistiku($savienojums, $lietotaja_id, 'merkesana', $no_datuma, $lidz_datuma);
$reakcijas_dati = iegut_statistiku($savienojums, $lietotaja_id, 'reakcija', $no_datuma, $lidz_datuma);

// Aprēķināt vidējo rezultātu
function aprekinat_videjo($dati) {
    if (count($dati) === 0) return 0;
    $summa = array_sum(array_column($dati, 'rezultats'));
    return $summa / count($dati);
}

$merkesanas_videjais = aprekinat_videjo($merkesanas_dati);
$reakcijas_videjais = aprekinat_videjo($reakcijas_dati);
?>

<!DOCTYPE html>
<html lang="lv">
<head>
<?php
session_start();
?>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Statistika</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="stils.css">
    <?php
    // sesijas savienošanās
session_start();

if (!isset($_SESSION['lietotaja_id'])) {
    header("Location: pieteikties.php");
    exit();
}
?>

</head>
<body>

<!-- Navigācijas josla -->
<nav class="navbar navbar-expand-lg navbar-light bg-light">
    <div class="container-fluid">
        <a class="navbar-brand" href="sakums.php">Logo</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navjosNav" aria-controls="navjosNav" aria-expanded="false" aria-label="Pārslēgt navigāciju">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navjosNav">
            <ul class="navbar-nav me-auto">
                <!-- Sākumlapas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="sakums.php">Sākumlapa</a>
                </li>
                <!-- Statistikas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="statistika.php">Statistika</a>
                </li>
                <!-- Pamācības poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="pamaciba.php">Kā spēlēt</a>
                </li>
            </ul>
            <ul class="navbar-nav">
                <!-- Pieteikšanās poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link active" href="pieteikties.php">Pieteikties</a>
                </li>
                <!-- Reģistrācijas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="registreties.php">Reģistrēties</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Galvenais saturs -->
<div class="container mt-5">
    <div class="row">

        <!-- Kreisā kolonna: Datumu izvēle un grafiks -->
        <div class="col-md-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <!-- Iespēja uzstādīt datuma diapazonas -->
                    <h5 class="card-title text-center">Datumu diapazons</h5>
                    <form>
                        <!-- Ievade priekš sākuma datuma -->
                        <div class="mb-3">
                            <label for="sakumDatums" class="form-label">No:</label>
                            <input type="date" class="form-control" id="sakumDatums" name="sakumDatums">
                        </div>
                        <!-- Ievade priekš beigu datuma -->
                        <div class="mb-3">
                            <label for="beiguDatums" class="form-label">Līdz:</label>
                            <input type="date" class="form-control" id="beiguDatums" name="beiguDatums">
                        </div>
                    </form>
                </div>
            </div>
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-center">Grafiks</h5>
                    <!-- Grafiks -->
                    <div style="height: 300px; background-color: #f8f9fa; border: 1px dashed #ced4da;">
                        <!-- Grafika saturs -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Mērķēšanas Trenētāja datu apskate -->
        <div class="col-md-4">
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h5 class="card-title text-center">Mērķēšanas trenētājs</h5>
            <p>Vidējais rezultāts: <strong><?php echo number_format($merkesanas_videjais, 2); ?></strong></p>
            <ul>
                <!-- Datuma veida izvades dati -->
                <?php foreach ($merkesanas_dati as $ieraksts): ?>
                    <li><?php echo $ieraksts['datums']; ?>: <?php echo $ieraksts['rezultats']; ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>
<!-- Reakcijas laika statistikas apskate -->
<div class="col-md-4">
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h5 class="card-title text-center">Reakcijas laika trenētājs</h5>
            <p>Vidējais rezultāts: <strong><?php echo number_format($reakcijas_videjais, 2); ?></strong></p>
            <ul>
                <!-- Datuma veida izvades dati -->
                <?php foreach ($reakcijas_dati as $ieraksts): ?>
                    <li><?php echo $ieraksts['datums']; ?>: <?php echo $ieraksts['rezultats']; ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>


    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
