<!DOCTYPE html>
<html lang="lv">
<head>
<?php
session_start();
?>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kā spēlēt</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        function pamacibasIzv(game) {
            const pamaciba = {
                "merkesanas": "Mērķēšanas Trenēšana: Tavs uzdevums ir uzlabot mērķēšanas prasmes, cik vien iespējams ātri un precīzi trāpot mērķos.",
                "reakcijas": "Reakcijas Laika Trenēšana: Pārbaudi un uzlabo savu reakcijas ātrumu, noklikšķinot, tiklīdz parādās mērķis."
            };
            document.getElementById("pamaciba").innerText = pamaciba[game];
        }
    </script>
</head>
<body>

<!-- Navigācijas josla -->
<nav class="navbar navbar-expand-lg navbar-light bg-light">
    <div class="container-fluid">
        <a class="navbar-brand" href="sakums.php">Logo</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navjosNav" aria-controls="navjosNav" aria-expanded="false" aria-label="Pārslēgt navigāciju">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navjosNav">
            <ul class="navbar-nav me-auto">
                <!-- Sākumlapas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="sakums.php">Sākumlapa</a>
                </li>
                <!-- Statistikas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="statistika.php">Statistika</a>
                </li>
                <!-- Pamācības poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="pamaciba.php">Kā spēlēt</a>
                </li>
            </ul>
            <ul class="navbar-nav">
                <!-- Pieteikšanās poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link active" href="pieteikties.php">Pieteikties</a>
                </li>
                <!-- Reģistrācijas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="registreties.php">Reģistrēties</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Galvenā satura sadaļa -->
<div class="container-fluid mt-4">
    <div class="row">

        <!-- Kreisā izvēlne: Mērķēšanas Trenētājs un Reakcijas Laika Trenētājs pogas -->
        <div class="col-md-2">
            <div class="d-grid gap-3">
                <button class="btn btn-outline-primary" onclick="pamacibasIzv('merkesanas')">Mērķēšanas Trenētājs</button>
                <button class="btn btn-outline-secondary" onclick="pamacibasIzv('reakcijas')">Reakcijas Laika Trenētājs</button>
            </div>
        </div>

        <!-- Centrālais saturs: Spēles instrukcijas -->
        <div class="col-md-10">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-center">Mērķēšanas Trenētājs / Reakcijas Laika Trenētājs</h5>
                    <p id="pamaciba" class="mt-4">Kā spēlēt: Noklikšķini uz pogas kreisajā pusē, lai redzētu instrukcijas.</p>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
