<?php
require 'savienojums.php'; // Savienojums ar datubāzi

session_start();// sesijas sākšana

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $epasts = trim($_POST['epasts']);
    $parole = trim($_POST['parole']);

    // Validācija
    if (empty($epasts) || empty($parole)) {
        die("Visi lauki ir jāaizpilda.");
    }

    // Lietotāja meklēšana datubāzē
    $sql = "SELECT * FROM lietotaji WHERE epasts = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $epasts);
    $stmt->execute();
    $rezultats = $stmt->get_result();

    if ($rezultats->num_rows > 0) {
        $lietotajs = $rezultats->fetch_assoc();

        // Paroles pārbaude
        if (password_verify($parole, $lietotajs['parole'])) {
            // Saglabāt sesijas datus
            $_SESSION['lietotaja_id'] = $lietotajs['id'];
            $_SESSION['epasts'] = $lietotajs['epasts'];

            // Pāradresācija uz sākumlapu
            header("Location: sakums.php");
            exit();
        } else {
            echo "Nepareiza parole.";
        }
    } else {
        echo "Lietotājs ar šo e-pastu neeksistē.";
    }

    $stmt->close();
}
$conn->close();
?>
