document.addEventListener("DOMContentLoaded", function() {
    // Funkcija, lai formatētu datumu uz "dd.mm.yyyy"
    function formatDate(date) {
        const day = String(date.getDate()).padStart(2, '0');
        const month = String(date.getMonth() + 1).padStart(2, '0'); // mēnesis ir 0-based
        const year = date.getFullYear();
        return `${day}.${month}.${year}`;
    }

    // Pievieno sākuma un beigu datumu formātus
    const sakumDatums = document.getElementById('sakumDatums');
    const beiguDatums = document.getElementById('beiguDatums');

    // Iegūst pašreizējo datumu un formatē to
    const today = new Date();
    sakumDatums.value = formatDate(today);
    beiguDatums.value = formatDate(today);

    // Pievienoju notikumu, lai, kad ievade ir mainīta, tas paliktu formātā "dd.mm.yyyy"
    sakumDatums.addEventListener('blur', function() {
        const dateParts = sakumDatums.value.split('.');
        if (dateParts.length === 3) {
            const formattedDate = new Date(`${dateParts[1]}/${dateParts[0]}/${dateParts[2]}`);
            sakumDatums.value = formatDate(formattedDate);
        }
    });

    
    beiguDatums.addEventListener('blur', function() {
        const dateParts = beiguDatums.value.split('.');
        if (dateParts.length === 3) {
            const formattedDate = new Date(`${dateParts[1]}/${dateParts[0]}/${dateParts[2]}`);
            beiguDatums.value = formatDate(formattedDate);
        }
    });
});
