const reakcijasZona = document.getElementById('reakcijasZona');
const stavoklis = document.getElementById('stavoklis');
const jusuLaiks = document.getElementById('jusuLaiks');

let sakumaLaiks = 0;
let reakcijasTreniņaStatuss = false;
// klikšķinot sāk trenētāju, taču kad jau ir bijusi spēle, tiek piefiksēts laiks
if (reakcijasZona) {
    reakcijasZona.addEventListener('click', () => {
        if (!reakcijasTreniņaStatuss) {
            sāktReakcijasTreniņu();
        } else {
            reģistrētReakciju();
        }
    });
}
// noklikšķinot sākas gaidīšanas stadija
function sāktReakcijasTreniņu() {
    stavoklis.textContent = 'Gaidiet...';
    reakcijasZona.classList.remove('active', 'waiting', 'finished');
    reakcijasZona.classList.add('waiting'); // Pievieno sarkano krāsu
    reakcijasTreniņaStatuss = true;

    // Nejaušs gaidīšanas laiks
    const gaidīšanasLaiks = Math.random() * 2000 + 1000;

    setTimeout(() => {
        stavoklis.textContent = 'Klikšķiniet tagad!';
        reakcijasZona.classList.remove('waiting');
        reakcijasZona.classList.add('active'); // Pievieno zaļo krāsu
        sakumaLaiks = Date.now();
    }, gaidīšanasLaiks);
}
//Piefiksē un pārbauda vai tika noklikšķināts pārāk agri un pāriet uz pirmo stadiju
function reģistrētReakciju() {
    if (!reakcijasZona.classList.contains('active')) {
        stavoklis.textContent = 'Pārāk ātri! Mēģiniet vēlreiz.';
        jusuLaiks.textContent = '---';
        reakcijasZona.classList.remove('active', 'waiting');
        reakcijasZona.classList.add('finished'); // Gaiši zila krāsa
        reakcijasTreniņaStatuss = false;
    } else {
        // gaida klikši vēlreiz uz zonas
        const reakcijasLaiks = Date.now() - sakumaLaiks;
        jusuLaiks.textContent = reakcijasLaiks;
        stavoklis.textContent = 'Noklikšķiniet, lai sāktu vēlreiz.';
        reakcijasZona.classList.remove('active', 'waiting');
        reakcijasZona.classList.add('finished'); // Gaiši zila krāsa
        reakcijasTreniņaStatuss = false;
    }
}
