const merkisZona = document.getElementById('spelesZona');
const saktSpeliPoga = document.getElementById('saktSpeli');
let dzivibas = 3;
let trapijumi = 0;
let garam = 0;
let spelestatuss = false;  // Spēle nav sākusies
let aktivaisMerkis = null;
let laiksSekundes = 0;
let taimeris = null;

// Sāk taimeri, kas atjaunina laika skaitītāju katru sekundi
function saktaimeri() {
    taimeris = setInterval(() => {
        laiksSekundes++;
        atjaunotLaikaRādījumu(); // Atjaunina laika parādīšanu uz ekrāna
    }, 1000);
}
// Atjauno laika rādījumu uz ekrāna
function atjaunotLaikaRādījumu() {
    const minutes = Math.floor(laiksSekundes / 60);
    const sekundes = laiksSekundes % 60;
    const laiksElement = document.getElementById('laiks');
    if (laiksElement) {
         // Formatē laiku kā MM:SS un parāda to elementā
        laiksElement.textContent = `${String(minutes).padStart(2, '0')}:${String(sekundes).padStart(2, '0')}`;
    }
}
// Aptur spēli, kad beidzas dzīvības vai spēle tiek pārtraukta
function apturētSpēli() {
    spelestatuss = false; // Norāda, ka spēle ir beigusies
    clearInterval(taimeris); // Aptur taimeri
    alert('Spēle ir beigusies! Mēģini vēlreiz!');
    if (merkisZona) merkisZona.innerHTML = ''; // Notīra mērķus no spēles zonas
    document.getElementById('spelesSakumsPoga').style.display = 'block'; // Rāda spēles sākšanas pogu
}
// Izveido jaunu mērķi spēles zonā
function izveidotMerkis() {
    if (!spelestatuss || !merkisZona) return;

    const merkis = document.createElement('div');
    merkis.classList.add('merkis');
    // Ģenerē nejaušu pozīciju mērķim spēles zonā
    const x = Math.random() * (merkisZona.offsetWidth - 50);
    const y = Math.random() * (merkisZona.offsetHeight - 50);
    merkis.style.left = `${x}px`;
    merkis.style.top = `${y}px`;
 // Notikums, kas tiek izsaukts, kad mērķis tiek trāpīts
    merkis.addEventListener('click', () => {
        if (!spelestatuss) return; // Pārbauda, vai spēle ir aktīva
        trapijumi++;
        atjaunotStatistiku();
        merkis.remove();
        aktivaisMerkis = null;
        izveidotMerkis();
    });

    merkisZona.appendChild(merkis);
    aktivaisMerkis = merkis;
// Pārbauda, vai mērķis ir izlaists, ja tas netiek klikšķināts laika limitā
    setTimeout(() => {
        if (merkisZona.contains(merkis) && spelestatuss) {
            merkis.remove();
            aktivaisMerkis = null;
            zaudetDzivibu();
            izveidotMerkis();
        }
    }, 1000);
}
// Lietotājs zaudē vienu dzīvību
function zaudetDzivibu() {
    if (!spelestatuss || dzivibas <= 0) return;
    dzivibas--;
    garam++;
    atjaunotStatistiku();

    if (dzivibas <= 0) {
        apturētSpēli();
    }
}
// Atjauno statistikas rādījumus uz ekrāna
function atjaunotStatistiku() {
    document.getElementById('trapits').textContent = trapijumi;
    document.getElementById('garam').textContent = garam;
    document.getElementById('dzivibas').textContent = dzivibas;

    const precizitateElement = document.getElementById('precizitate');
    if (precizitateElement) {
        // Aprēķina precizitāti (trāpījumu procents) un atjauno uz ekrāna
        const precizitate = trapijumi + garam > 0 ? Math.round((trapijumi / (trapijumi + garam)) * 100) : 0;
        precizitateElement.textContent = `${precizitate}%`;
    }
}

// Sāk spēli, atiestatot visus rādītājus un stāvokļus
function sāktSpēli() {
    spelestatuss = true;
    dzivibas = 3;
    trapijumi = 0;
    garam = 0;
    laiksSekundes = 0;
    atjaunotStatistiku();
    saktaimeri();
    izveidotMerkis();
    document.getElementById('spelesSakumsPoga').style.display = 'none'; // Paslēpt spēles sākšanas pogu
}

// Poga, lai uzsāktu spēli
saktSpeliPoga.addEventListener('click', sāktSpēli);
