<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reģistrācija</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Navigācijas josla -->
<nav class="navbar navbar-expand-lg navbar-light bg-light">
    <div class="container-fluid">
        <a class="navbar-brand" href="sakums.php">Logo</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navjosNav" aria-controls="navjosNav" aria-expanded="false" aria-label="Pārslēgt navigāciju">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navjosNav">
            <ul class="navbar-nav me-auto">
                <!-- Sākumlapas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="sakums.php">Sākumlapa</a>
                </li>
                <!-- Statistikas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="statistika.php">Statistika</a>
                </li>
                <!-- Pamācības poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="pamaciba.php">Kā spēlēt</a>
                </li>
            </ul>
            <ul class="navbar-nav">
                <!-- Pieteikšanās poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link active" href="pieteikties.php">Pieteikties</a>
                </li>
                <!-- Reģistrācijas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="registreties.php">Reģistrēties</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Reģistrācijas forma -->
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h3 class="card-title text-center mb-4">Reģistrēties</h3>
                    <!-- Reģistrācijas iegūšanas funkcija (Vēl nav) -->
                    <form action="signup_process.php" method="POST">
                        <!-- E-pasta ievades lauks -->
                        <div class="mb-3">
                            <label for="epasts" class="form-label">E-Pasts</label>
                            <input type="email" class="form-control" id="epasts" name="epasts" required>
                        </div>
                        <!-- Paroles ievades lauks -->
                        <div class="mb-3">
                            <label for="parole" class="form-label">Parole</label>
                            <input type="password" class="form-control" id="parole" name="parole" required>
                        </div>
                        <!-- Paroles apstiprināšanas ievades lauks -->
                        <div class="mb-3">
                            <label for="apstipr_parole" class="form-label">Apstipriniet paroli</label>
                            <input type="password" class="form-control" id="apstipr_parole" name="apstipr_parole" required>
                        </div>
                        <!-- Reģistrācijas poga -->
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Reģistrēties</button>
                        </div>
                    </form>
                    <!-- Iespēja doties uz pieteikšanās logu -->
                    <div class="text-center mt-3">
                        <a href="pieteikties.php">Jau ir konts? Pieslēgties</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
