<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mērķēšanas Trenētājs</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Navigācijas josla -->
<nav class="navbar navbar-expand-lg navbar-light bg-light">
    <div class="container-fluid">
        <a class="navbar-brand" href="sakums.php">Logo</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navjosNav" aria-controls="navjosNav" aria-expanded="false" aria-label="Pārslēgt navigāciju">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navjosNav">
            <ul class="navbar-nav me-auto">
                <!-- Sākumlapas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="sakums.php">Sākumlapa</a>
                </li>
                <!-- Statistikas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="statistika.php">Statistika</a>
                </li>
                <!-- Pamācības poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="pamaciba.php">Kā spēlēt</a>
                </li>
            </ul>
            <ul class="navbar-nav">
                <!-- Pieteikšanās poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link active" href="pieteikties.php">Pieteikties</a>
                </li>
                <!-- Reģistrācijas poga navigācijas joslā -->
                <li class="nav-item">
                    <a class="nav-link" href="registreties.php">Reģistrēties</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Galvenais saturs -->
<div class="container-fluid mt-4">
    <div class="row justify-content-center">
        <!-- Trenēšanas konteiners -->
        <div class="col-10">
            <div class="card text-center">
                <div class="card-body">
                    <!-- Trenēšanas zona -->
                    <div class="mb-4" style="height: 400px; border: 1px solid #ddd;">
                        <button id="playButton" class="btn btn-primary btn-lg" style="position: relative; top: 50%; transform: translateY(-50%);">Spēlēt</button>
                    </div>

                    <!-- Trenēšanas statistika -->
                    <div class="row">
                        <div class="col">
                            <div class="card">
                                <!-- Parāda laiku -->
                                <div class="card-body">
                                    <strong>Laiks:</strong> <span id="laiks">00:00:00</span>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <!-- Parāda cik reizes tika trāpīts pa mērķi -->
                                <div class="card-body">
                                    <strong>Trāpījumi:</strong> <span id="trapits">0</span>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <!-- Parāda cik reizes garām trāpija -->
                                <div class="card-body">
                                    <strong>Garām:</strong> <span id="garam">0</span>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <!-- Parāda aprēķināto precizitāti -->
                                <div class="card-body">
                                    <strong>Precizitāte:</strong> <span id="precizitate">0%</span>
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="card">
                                <!-- Parāda cik dzīvības ir atlikušas -->
                                <div class="card-body">
                                    <strong>Dzīvības:</strong> <span id="dzivibas">3</span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
