document.getElementById("carForm").addEventListener("submit", function(event) {
    event.preventDefault(); // Prevent the form from submitting the traditional way

    var formData = new FormData(this);

    // Send the form data using an AJAX request
    fetch("php/register_car.php", {
        method: "POST",
        body: formData
    })
        .then(response => response.text())
        .then(result => {
            if (result === "success") {
                alert("Your car data has been successfully registered!");
                document.getElementById("carForm").reset(); // Reset the form
            } else if (result === "duplicate_vin") {
                alert("Error: The VIN number already exists in the system.");
            } else {
                alert("Error: Unable to register car data.");
            }
        })
        .catch(error => {
            console.error("Error:", error);
        });
});
